package ru.yandex.autotests.innerpochta.wmi.core.matchers.ssh;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.TcpdumpRule;

import java.io.IOException;

import static org.hamcrest.CoreMatchers.equalTo;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 22.11.13
 * Time: 17:12
 */
public class TcpdumpLogMatcher extends TypeSafeMatcher<TcpdumpRule> {

    protected final Logger logger = LogManager.getLogger(this.getClass());

    private String query;
    Matcher<Integer> matcher;

    public TcpdumpLogMatcher(String query, Matcher<Integer> matcher) {
        this.query = query;
        this.matcher = matcher;
    }

    @Factory
    public static TcpdumpLogMatcher hasQuery(String query, Matcher<Integer> matcher) {
        return new TcpdumpLogMatcher(query, matcher);
    }

    @Factory
    public static TcpdumpLogMatcher hasOneQuery(String query) {
        return new TcpdumpLogMatcher(query, equalTo(1));
    }

    @Override
    protected boolean matchesSafely(TcpdumpRule tcpdumpRule) {
        try {
            Integer result = Integer.parseInt(StringUtils.chomp(tcpdumpRule.grepFromLog(query)));
            return matcher.matches(result);
        } catch (IOException e) {
            throw new RuntimeException("не удалось открыть лог для поиска запроса ", e);
        }
    }

    @Override
    public void describeMismatchSafely(TcpdumpRule tcpdumpRule, Description mismatchDescription) {
        try {
            mismatchDescription.appendText(String.format("в логе %s:%n%s",
                    TcpdumpRule.PATH_TO_LOG, tcpdumpRule.getLog()));
        } catch (Exception e) {
            throw new RuntimeException("не удалось открыть лог для поиска запроса ", e);
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("в логе %s будет строчка %s\n", TcpdumpRule.PATH_TO_LOG, query));
    }
}
