package ru.yandex.autotests.innerpochta.wmi.core.mbody;

import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.specification.ResponseSpecification;
import org.apache.http.HttpStatus;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.autotests.innerpochta.beans.mbody.Mbody;

import static org.hamcrest.Matchers.*;
import static ru.yandex.autotests.innerpochta.beans.mbody.BodyMatchers.withTransformerResult;
import static ru.yandex.autotests.innerpochta.beans.mbody.MbodyMatchers.withBodies;
import static ru.yandex.autotests.innerpochta.beans.mbody.TextTransformerResultMatchers.withContent;
import static ru.yandex.autotests.innerpochta.beans.mbody.TransformerResultMatchers.withTextTransformerResult;

public class MbodyResponses {
    public static ResponseSpecification ok200(){
        return new ResponseSpecBuilder()
            .expectStatusCode(HttpStatus.SC_OK)
            .build();
    }

    public static ResponseSpecification missingParam400(String error) {
        return badRequest400(error);
    }

    public static ResponseSpecification badRequest400(String error) {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_BAD_REQUEST)
                .expectBody("result", is("invalid request"))
                .expectBody("error", containsString(error))
                .build();
    }

    public static ResponseSpecification error500WithString(String error){
        return new ResponseSpecBuilder()
            .expectStatusCode(HttpStatus.SC_INTERNAL_SERVER_ERROR)
            .expectBody("result", is("internal error"))
            .expectBody("error", containsString(error))
            .build();
    }
}
