package ru.yandex.autotests.innerpochta.wmi.core.mops;

import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.specification.ResponseSpecification;
import org.apache.http.HttpStatus;
import org.hamcrest.Matcher;

import static org.hamcrest.Matchers.*;

/**
 * Created by emilchess on 10/03/17.
 */
public class MopsResponses {
    public static ResponseSpecification okSyncOrAsync() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody("taskType", anyOf(equalTo("sync"), equalTo("async")))
                .build();
    }

    public static ResponseSpecification okEmptyJson() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .build();
    }

    public static ResponseSpecification okFid() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody("fid", not(isEmptyOrNullString()))
                .build();
    }

    public static ResponseSpecification okUnsubscribe() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody(not(isEmptyOrNullString()))
                .build();
    }

    public static ResponseSpecification okLid() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody("lid", not(isEmptyOrNullString()))
                .build();
    }

    public static ResponseSpecification okSync() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody("taskType", equalTo("sync"))
                .expectBody("taskGroupId", is(nullValue()))
                .build();
    }

    public static ResponseSpecification okAsync() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody("taskType", equalTo("async"))
                .expectBody("taskGroupId", not(isEmptyOrNullString()))
                .build();
    }

    public static ResponseSpecification invalidRequest() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_BAD_REQUEST)
                .expectBody("result", equalTo("invalid request"))
                .build();
    }

    public static ResponseSpecification invalidRequest(Matcher<?> messageMatcher) {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_BAD_REQUEST)
                .expectBody("result", equalTo("invalid request"))
                .expectBody("error", messageMatcher)
                .build();
    }

    public static ResponseSpecification internalError() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_INTERNAL_SERVER_ERROR)
                .expectBody("result", equalTo("internal error"))
                .build();
    }

    public static ResponseSpecification internalError(Matcher<?> messageMatcher) {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_INTERNAL_SERVER_ERROR)
                .expectBody("result", equalTo("internal error"))
                .expectBody("error", messageMatcher)
                .build();
    }

    public static ResponseSpecification missingExpectedParam() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_BAD_REQUEST)
                .expectBody("message", equalTo("missing expected param"))
                .build();
    }

    public static ResponseSpecification stickerDoesNotExist() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_BAD_REQUEST)
                .expectBody("message", equalTo("reply_later sticker does not exist on this envelope"))
                .build();
    }

    public static ResponseSpecification stickerWrongDate() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_BAD_REQUEST)
                .expectBody("message", equalTo("sticker's date is out of allowed interval"))
                .build();
    }
}
