package ru.yandex.autotests.innerpochta.wmi.core.oauth;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.hamcrest.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.autotests.innerpochta.objstruct.base.misc.Account;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Scopes;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import static com.jayway.restassured.RestAssured.given;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 18.09.12
 * Time: 16:55
 */
public class OAuthRequestInterceptor implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthRequestInterceptor.class);
    private static Map<String, String> tokens = new ConcurrentHashMap<>();
    private String token;

    public OAuthRequestInterceptor(String token) {
        this.token = token;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        request.addHeader(new BasicHeader("Authorization", "OAuth " + token));
        LOG.info("OAuthRequestInterceptor: Header added - Authorization: OAuth {}", token);
    }

    @Factory
    public static OAuthRequestInterceptor getOAuthInterceptor(String token) throws Exception {
        return new OAuthRequestInterceptor(token);
    }

    /**
     * Получение токена по-топорному
     * Подробности об OAuth: http://api.yandex.ru/oauth/doc/dg/concepts/About.xml
     *
     * @param account    аккаунт пользователя
     * @return Строка - токен
     * @throws Exception *
     */
    public static String getToken(Account account) throws Exception {
        if (props().scope().equals(Scopes.INTRANET_PRODUCTION)) {
            return tokens.computeIfAbsent(account.getLogin(), key -> {
                LOG.info("action=get_oauth_token login={}", account.getLogin());
                return given()
                    .queryParam("user_ip", hostAddr())
                    .multiPart("grant_type", "password")
                    .multiPart("username", account.getLogin())
                    .multiPart("password", account.getPassword())
                    //тестовое приложение со скоупом mobmail:all нужно для DARIA-49326
                    .multiPart("client_id", "1d11b482c61d4bd0a4216a8fc5d51812")
                    .multiPart("client_secret", "81b2b7302f4c4b4abe4381f6c6e029de")
                    .post("https://oauth.yandex-team.ru/token").jsonPath().getString("access_token");
            });
        } else if (props().scope().equals(Scopes.PRODUCTION)) {
            return tokens.computeIfAbsent(account.getLogin(), key -> {
                LOG.info("action=get_oauth_token login={}", account.getLogin());
                return given()
                        .queryParam("user_ip", hostAddr())
                        .multiPart("grant_type", "password")
                        .multiPart("username", account.getLogin())
                        .multiPart("password", account.getPassword())
                        //тестовое приложение со скоупом mobmail:all нужно для DARIA-49326
                        .multiPart("client_id", "e7618c5efed842be839cc9a580be94aa")
                        .multiPart("client_secret", "81a97a4e05094a4c96e9f5fa0b21f794")
                        .post("https://oauth.yandex.ru/token").jsonPath().getString("access_token");
            });
        } else {
            return tokens.computeIfAbsent(account.getLogin(), key -> {
                LOG.info("action=get_oauth_token login={}", account.getLogin());
                return given()
                        .queryParam("user_ip", hostAddr())
                        .multiPart("grant_type", "password")
                        .multiPart("username", account.getLogin())
                        .multiPart("password", account.getPassword())
                        //тестовое приложение со скоупом mobmail:all нужно для DARIA-49326
                        .multiPart("client_id", "44ed657adbc844b1885d78491ff71799")
                        .multiPart("client_secret", "569e615d092f4fed9b74243abfb460c1")
                        .post("https://oauth-test.yandex.ru/token").jsonPath().getString("access_token");
            });
        }
    }

    public static String getToken(String login, String pwd) throws Exception {
        return getToken(new Account(login, pwd));
    }

    private static String hostAddr() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }
}
