package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 12:01
 */
public class DariaMessagesObj extends MailBoxListObj {

    /**
     * @return DariaMessagesObj
     */
    public static DariaMessagesObj getEmptyObj() {
        return new DariaMessagesObj();
    }

    /**
     * Вывод конкретной папки
     *
     * @param fid - фид папки
     * @return DariaMessagesObj
     */
    public static DariaMessagesObj getObjCurrFolder(String fid) {
        return getEmptyObj().setCurrentFolder(fid);
    }

    /**
     * @param pageNumber - номер страницы
     * @return this
     */
    public DariaMessagesObj setPageNumber(String pageNumber) {
        super.setPageNumber(pageNumber);
        return this;
    }

    /**
     * @param currentFolderFID - текущая папка, fid
     * @return this
     */
    public DariaMessagesObj setCurrentFolder(String currentFolderFID) {
        super.setCurrentFolder(currentFolderFID);
        return this;
    }


    /**
     * @param sortType - поле сортировки
     *                 Бывает: строка (subj[1] по теме – [1] по возрастанию; from[1] – по отправителю;
     *                 date[1] – по дате; size[1] – по размеру; stat[1] – по статусу;
     *                 atta[1] – по аттачментам, завирусованности; ord[1] – по порядку получения;
     * @return this
     */
    public DariaMessagesObj setSortType(String sortType) {
        super.setSortType(sortType);
        return this;
    }

    /**
     * @param goTo - в какой папке смотрим
     *             Бывает: (spam,sent,draft,inbox)
     * @return this
     */
    public DariaMessagesObj setGoto(String goTo) {
        super.setGoto(goTo);
        return this;
    }

    /**
     * @param extraCond - отбор по доп условиям
     *                  Бывает: строка ('only_new' или 'only_atta')
     * @return this
     */
    public DariaMessagesObj setExtraCond(String extraCond) {
        super.setExtraCond(extraCond);
        return this;
    }

    /**
     * @param currentLabel: lid текущей метки (имеет больший приоритет, чем current_folder или goto)
     * @return this
     */
    public DariaMessagesObj setCurrentLabel(String currentLabel) {
        super.setCurrentLabel(currentLabel);
        return this;
    }


    /**
     * Выставляет идентификатор темы
     *
     * @param threadId - id темы
     * @return ThreadListObj
     */
    public DariaMessagesObj setThreadId(String threadId) {
        set("thread_id", threadId);
        return this;
    }

    public DariaMessagesObj withPins() {
        set("with_pins", "yes");
        return this;
    }

    public DariaMessagesObj threaded() {
        set("threaded", "yes");
        return this;
    }


}
