package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 */
public class FolderMoveAllMessagesObj extends Obj {

    /**
     * Возвращает объект с настройками для перемещения писем
     *
     * @return FolderMoveAllMessagesObj
     */
    public static FolderMoveAllMessagesObj getEmptyObj() {
        return new FolderMoveAllMessagesObj();
    }

    /**
     * Возвращает объект для перемещения всех писем из одной папки в другую
     *
     * @param fromFid - папка источник
     * @param toFid   - папка назначение
     * @return FolderMoveAllMessagesObj
     */
    public static FolderMoveAllMessagesObj move(String fromFid, String toFid) {
        return getEmptyObj().setSrcfid(fromFid).setDstfid(toFid);
    }

    /**
     * фид папки источника
     *
     * @param srcfid - папка источник
     * @return this
     */
    public FolderMoveAllMessagesObj setSrcfid(String srcfid) {
        set("srcfid", srcfid);
        return this;
    }


    /**
     * фид папки назначения
     *
     * @param dstfid - папка назначения
     * @return this
     */
    public FolderMoveAllMessagesObj setDstfid(String dstfid) {
        set("dstfid", dstfid);
        return this;
    }
}
