package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Используется ручкой api/in_reply_to
 */
public class InReplyToObj extends Obj {

    /**
     * Возвращает объект с настройками конкретного письма
     *
     * @return InReplyToObj
     */
    public static InReplyToObj getEmptyObj() {
        return new InReplyToObj();
    }

    /**
     * Возвращает объект, подготовленный для получения письма с заданным mid
     *
     * @param mid - заданный mid
     * @return InReplyToObj
     */
    public static InReplyToObj getMsg(String mid) {
        return getEmptyObj().setMid(mid);
    }

    /**
     * идентификатор письма для просмотра
     *
     * @param mid - mid письма
     * @return MessageObj
     */
    public InReplyToObj setMid(String mid) {
        set("mid", mid);
        return this;
    }

}
