package ru.yandex.autotests.innerpochta.wmi.core.obj;

import org.hamcrest.Factory;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 12:01
 */
public class MailBoxListObj extends Obj {


    /**
     * @param pageNumber - номер страницы
     * @return this
     */
    public MailBoxListObj setPageNumber(String pageNumber) {
        set("page_number", pageNumber);
        return this;
    }

    public MailBoxListObj setPageNumber(Integer pageNumber) {
        setPageNumber(pageNumber.toString());
        return this;
    }

    /**
     * @param currentFolderFID - текущая папка, fid
     * @return this
     */
    public MailBoxListObj setCurrentFolder(String currentFolderFID) {
        set("current_folder", currentFolderFID);
        return this;
    }

    /**
     * @param first - номер первого заголовка в выдаче (начинается с 0)
     * @return this
     */

    public MailBoxListObj setFirst(Integer first) {
        set("first", first.toString());
        return this;
    }

    /**
     * @param last - номер последнего заголовка в выдаче
     * @return this
     */

    public MailBoxListObj setLast(Integer last) {
        set("last", last.toString());
        return this;
    }


    /**
     * @param sortType - поле сортировки
     *                 Бывает: строка (subj[1] по теме – [1] по возрастанию; from[1] – по отправителю;
     *                 date[1] – по дате; size[1] – по размеру; stat[1] – по статусу;
     *                 atta[1] – по аттачментам, завирусованности; ord[1] – по порядку получения;
     * @return this
     */
    public MailBoxListObj setSortType(String sortType) {
        set("sort_type", sortType);
        return this;
    }

    // https://github.yandex-team.ru/mail/wmi/blob/master/meta_access/mailbox_list_aux.hpp#L74-L106
    //-------------------------------------------------------
    public static final String SORT_DATE = "date"; // По дате
    public static final String SORT_DATE_ASC = "date1"; // По дате, начиная со старых
    public static final String SORT_SUBJ_DESC = "subject1"; // По теме
    //public static final String SORT_ASC = "[1]"; // По возрастанию - не работает
    public static final String SORT_SIZE = "size[1]"; // По размеру
    public static final String SORT_FROM = "from[1]"; // По отправителю
    public static final String SORT_STAT = "stat[1]"; // По статусу
    public static final String SORT_ATTA = "atta[1]"; // По аттачментам, завирусованности
    public static final String SORT_ORD = "ord[1]"; // По порядку получения
    //---------------------------------------------------------


    /**
     * @param goTo - в какой папке смотрим
     *             Бывает: (spam,sent,draft,inbox)
     * @return this
     */
    public MailBoxListObj setGoto(String goTo) {
        set("goto", goTo);
        return this;
    }

    //-------------------------------------------------
    public static final String GOTO_SPAM = "spam"; // Показываем спам
    public static final String GOTO_TRASH = "trash"; // Показываем удаленные
    public static final String GOTO_SENT = "sent"; // Показываем отправленные
    public static final String GOTO_DRAFT = "draft"; // Показываем черновики
    public static final String GOTO_INBOX = "inbox"; // Показываем входящие
    public static final String GOTO_OUTBOX = "outbox"; // Показываем исходящие
    public static final String GOTO_ALL = "all"; // Показываем все
    //---------------------------------------------------------------


    /**
     * @param extraCond - отбор по доп условиям
     *                  Бывает: строка ('only_new' или 'only_atta')
     * @return this
     */
    public MailBoxListObj setExtraCond(String extraCond) {
        set("extra_cond", extraCond);
        return this;
    }

    //--------------------------------------------------------
    public static final String EXTRA_NEW = "only_new"; // Показываем новые
    public static final String EXTRA_ATTA = "only_atta"; // Показываем с вложениями
    //---------------------------------------------------------------


    /**
     * @param currentLabel: lid текущей метки (имеет больший приоритет, чем current_folder или goto)
     * @return this
     */
    public MailBoxListObj setCurrentLabel(String currentLabel) {
        set("current_label", currentLabel);
        return this;
    }


    /**
     * В каком виде отображать
     *
     * @param xmlVersion - вид отображения
     *                   Бывает: daria2, default ...
     * @return MailboxListNearestInThreadObj
     */
    public MailBoxListObj setXmlVersion(String xmlVersion) {
        set("xml_version", xmlVersion);
        return this;
    }

    /**
     * [DARIA-34367]
     * @param since
     * @return this
     */
    public MailBoxListObj setSince(String since) {
        set("since", since);
        return this;
    }

    /**
     * [DARIA-34367]
     * @param till
     * @return this
     */
    public MailBoxListObj setTill(String till) {
        set("till", till);
        return this;
    }

    /**
     * Копирует все свойства из текущего объекта, в объект-наследник
     * необходимо чтобы добавить свойства from и to
     *
     * @return PagerMailboxListObj - объект педжера
     */
    public PagerMailboxListObj copyToPagerObj() {
        PagerMailboxListObj obj = new PagerMailboxListObj();
        obj.queryParams.putAll(this.queryParams);
        obj.params.putAll(this.params);
        return obj;
    }


    /**
     * По умолчанию сортировка по дате
     *
     * @return MailBoxListObj
     */
    @Factory
    public static MailBoxListObj empty() {
        return new MailBoxListObj().setSortType(MailBoxListObj.SORT_DATE);
    }

    /**
     * Получает объект с указанной папкой
     *
     * @param fid - фид папки
     * @return MailBoxListObj
     */
    @Factory
    public static MailBoxListObj inFid(String fid) {
        return empty().setCurrentFolder(fid);
    }

}
