package ru.yandex.autotests.innerpochta.wmi.core.obj;

import com.google.gson.Gson;
import ru.yandex.autotests.innerpochta.beans.mailsend.PartsJson;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;

import static com.google.common.collect.Lists.newArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 21.03.12
 * Time: 16:15
 */
public class MailSendMsgObj extends Obj {
    /**
     * Ручка mail_send
     * Или /jsxapi/simple.jsx?wmi-method=send_message  (Это другая функция!)
     * <p/>
     * <p/>
     * send_time - дата в формате yyyy-MM-dd HH:mm:ss
     * compose_check - мд5(suid)
     * <p/>
     * from_mailbox: обратный адрес
     * to : список адресов «кому»
     * cc : список адресов «копия»
     * bcc: список адресов «скрытая копия»
     * ttype: тип тела html|plain
     * inreplyto: In-Reply-To письма
     * references: References письма
     * subj: тема письма
     * send: текст (тело) письма
     * ids: список id-шников вложенных писем
     * att: массив аттачментов.
     * <p/>
     * rotate: массив значениями углов поворота соответствующей картинки
     * <p/>
     * parts: идентификаторы messagePart которые нужно оставить в письме (при редактировании из черновика)
     * idcs: ids| fmids - прикрепляем письмо по миду (eml - аттачи)
     * mark_as: replied/forwarded
     * <p/>
     * управление письмом
     * nosend: не отсылать письмо
     * nosave: не сохранять письмо
     * overwrite: Id письма на основе которого строится форма
     * ign_overwrite: переписываем ли письмо на основе которого создаем сообщение
     * confirm_limit: повторная отправка без проверки размера сообщения
     * autosave: параметр используется для определения ситуации когда отправляется аяксовый запрос на сохранение
     * store_fid: id фолдера, куда нужно сохранить письмо.
     * store_name: имя системного фолдера куда нужно сохранить письмо (inbox, etc как goto в mailbox-e)
     * <p/>
     * интерфейс
     * style: информация о стиле на который перейдем после отправки сообщения
     * captcha_entered: введённая капча
     * where == retpath: ручной переброс в xsl
     * returl: урла по которой происходит переход после выполнения модуля отправки. должна быть с параметром на конце
     * к ней добавляется два параметра subject и storemid. С соотв содержанием.
     * <p/>
     * <p/>
     * Сохраняется в черновики пока только апи ручкой
     */

    public static MailSendMsgObj msg() {
        return new MailSendMsgObj().setSubj(Util.getRandomString());
    }

    public static MailSendMsgObj empty() {
        return new MailSendMsgObj();
    }

    /**
     * Делаем вид, что сохраняем исходящее письмо в черновик
     *
     * @return - объект письма с заполненной темой и адресатом для сохранения в черновик
     */
    public static MailSendMsgObj saveToDraft(String mid, MailSendMsgObj msg) {

        return new MailSendMsgObj().setComposeCheck(msg.getComposeCheck())
                .setTo(msg.getTo())
                .setSubj(msg.getSubj())
                .setSend(msg.getSend())
                .setSendTime(msg.getSendTime())
                .setIgnOverwrite("no")
                .setOverwrite(mid)
                .setNosend("yes");
    }

    public MailSendMsgObj() {
        set("cc", "");
    }

    public MailSendMsgObj listUnsubscribe() {
        remove("cc");
        return this;
    }

    /**
     * @param to адрес получателя. Можно указывать несколько через запятую
     * @return this
     */
    public MailSendMsgObj setTo(String to) {
        set("to", to);
        return this;
    }

    /**
     * Дополнительный параметр при вызове mail_send: "feed_address_db", если указан и равен "no",
     * то добавления не произойдёт.
     *
     * @return this
     */
    public MailSendMsgObj setFeedAddrdbNO() {
        set("feed_address_db", "no");
        return this;
    }

    /**
     * @param notifyOnSend - уведомление об отправке
     *                     Бывает: yes
     * @return this
     */
    public MailSendMsgObj setNotifyOnSend(String notifyOnSend) {
        set("notify_on_send", notifyOnSend);
        return this;
    }

    public MailSendMsgObj setComposeCheck(String composeCheck) {
        set("compose_check", composeCheck);
        return this;
    }

    public String getComposeCheck() {
        return getParam("compose_check");
    }

    /**
     * @param sendTime send_time - дата
     * @return *
     */
    public MailSendMsgObj setSendTime(Date sendTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return setSendTime(sdf.format(sendTime));
    }

    /**
     * @param sendTime send_time - дата строкой в формате yyyy-MM-dd HH:mm:ss
     * @return *
     */
    public MailSendMsgObj setSendTime(String sendTime) {
        set("send_time", sendTime);
        return this;
    }

    /**
     * Возврат строкового представления даты отправки
     *
     * @return String
     */
    public String getSendTime() {
        return getParam("send_time");
    }

    /**
     * Возврат строкового представления адресата
     *
     * @return String
     */
    public String getTo() {
        return getParam("to");
    }


    /**
     * @param fromMailbox обратный адрес
     * @return *
     */
    public MailSendMsgObj setFromMailbox(String fromMailbox) {
        set("from_mailbox", fromMailbox);
        return this;
    }

    /**
     * @param fromName обратный адрес
     * @return *
     */
    public MailSendMsgObj setFromName(String fromName) {
        set("from_name", fromName);
        return this;
    }

    public MailSendMsgObj setCc(String cc) {
        set("cc", cc);
        return this;
    }

    public MailSendMsgObj setBcc(String bcc) {
        set("bcc", bcc);
        return this;
    }

    public MailSendMsgObj setTtypeHtml() {
        set("ttype", "html");
        return this;
    }

    public MailSendMsgObj setTtypePlain() {
        set("ttype", "plain");
        return this;
    }

    public MailSendMsgObj setTtypeAny(String ttype) {
        set("ttype", ttype);
        return this;
    }

    public MailSendMsgObj setInreplyto(String inreplyto) {
        set("inreplyto", inreplyto);
        return this;
    }

    public MailSendMsgObj setReferences(String references) {
        set("references", references);
        return this;
    }

    /**
     * [WMI-577]
     *
     * @param client - его содержимое (если он не пуст) подставляется в заголовок X-Yandex-Client.
     *               Значение энкодится по rfc2047 (типа =?utf-8?B?cXdlCnJ0eTogdWlv?=),
     *               чтобы нельзя было туда прокинуть что-нибудь типа a;
     *               b: c и добавить в письмо произвольный заголовок
     * @return this
     */
    public MailSendMsgObj setClient(String client) {
        set("client", client);
        return this;
    }

    public MailSendMsgObj setSubj(String subj) {
        set("subj", subj);
        return this;
    }

    public String getSubj() {
        return getParam("subj");
    }

    public MailSendMsgObj setSend(String send) {
        set("send", send);
        return this;
    }

    public String getSend() {
        return getParam("send");
    }

    /**
     * Добавляет mid в список для пересылки этого письма
     *
     * @param ids - mid письма
     * @return this
     */
    public MailSendMsgObj addIds(String... ids) {
        add("ids", ids);
        return this;
    }

    public MailSendMsgObj addAttIds(String... ids) {
        add("att_ids", ids);
        return this;
    }

    /**
     * Очищает список подготовленных midов
     *
     * @return this
     */
    public MailSendMsgObj clearIds() {
        remove("ids");
        return this;
    }


    public MailSendMsgObj addAtts(File... atts) throws FileNotFoundException {
        addAtts("binary/octet-stream", atts);
        return this;
    }


    public MailSendMsgObj addAtts(String mimetype, File... atts) throws FileNotFoundException {
        addFile("att", mimetype, atts);
        return this;
    }


    /**
     * Добавляет к картинке угол
     * [DARIA-23739]
     * Для att.
     *
     * @return this
     */
    public MailSendMsgObj addRotate(String rotate) throws FileNotFoundException {
        add("att_rotate", rotate);
        return this;
    }

    public MailSendMsgObj setParts(String parts) {
        set("parts", parts);
        return this;
    }


    public MailSendMsgObj addParts(String parts) {
        add("parts", parts);
        return this;
    }

    public MailSendMsgObj setIdcs(String idcs) {
        set("idcs", idcs);
        return this;
    }

    public MailSendMsgObj setMarkAs(String markAs) {
        set("mark_as", markAs);
        return this;
    }

    /**
     * @param markIds - mid сообщения для пометки
     * @return this
     */
    public MailSendMsgObj setMarkIds(String markIds) {
        set("mark_ids", markIds);
        return this;
    }

    public MailSendMsgObj setNosend(String nosend) {
        set("nosend", nosend);
        return this;
    }

    public MailSendMsgObj setNosave(String nosave) {
        set("nosave", nosave);
        return this;
    }

    public MailSendMsgObj setOverwrite(String overwrite) {
        set("overwrite", overwrite);
        return this;
    }

    public MailSendMsgObj setIgnOverwrite(String ignOverwrite) {
        set("ign_overwrite", ignOverwrite);
        return this;
    }


    public MailSendMsgObj setConfirmLimit(String confirmLimit) {
        set("confirm_limit", confirmLimit);
        return this;
    }


    public MailSendMsgObj setAutosave(String autosave) {
        set("autosave", autosave);
        return this;
    }

    public MailSendMsgObj setStoreFid(String storeFid) {
        set("store_fid", storeFid);
        return this;
    }

    public MailSendMsgObj setStoreName(String storeName) {
        set("store_name", storeName);
        return this;
    }


    public MailSendMsgObj setStyle(String style) {
        set("style", style);
        return this;
    }

    public MailSendMsgObj setCaptchaEntered(String captchaEntered) {
        set("captcha_entered", captchaEntered);
        return this;
    }

    public MailSendMsgObj setWhere(String where) {
        set("where", where);
        return this;
    }

    public MailSendMsgObj setReturl(String returl) {
        set("returl", returl);
        return this;
    }

    /**
     * добавляет к письму деньги
     * [DARIA-30196]
     *
     * @return this
     */
    public MailSendMsgObj yamoney() {
        set("yamoney", "name=\"123cd15b39e2e3690d58820855adb9b5\"");
        return this;
    }

    /**
     * Добавляем параметр для вложений:
     * parts_json=[{"mid": 2160000000004415415, "id": 1.2, "rotate": 90}]
     * [DARIA-29427]
     *
     * @param partsJson
     * @return
     */
    public MailSendMsgObj withPartsJson(String partsJson) {
        set("parts_json", partsJson);
        return this;
    }

    public MailSendMsgObj withPartsJson(PartsJson... partsJson) {
        return withPartsJson(new Gson().toJson(newArrayList(partsJson)));
    }

    /**
     * Добавляем параметр для календаря
     * [DARIA-31535]
     *
     * @param sec
     * @return
     */
    public MailSendMsgObj setRemindPeriod(String sec) {
        set("remind_period", sec);
        return this;
    }

    public MailSendMsgObj setLids(String lids) {
        set("lids", lids);
        return this;
    }

    public MailSendMsgObj setCaptchaKey(String captchaKey) {
        set("captcha_key", captchaKey);
        return this;
    }
}
