package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Ручка mailbox_list_nearest
 * <p/>
 * current_folder : fid текущего фолдера
 * sort_type : тип сортировки: строка (subj[1] по теме – [1] по возрастанию; from[1] – по отправителю;
 * date[1] – по дате; size[1] – по размеру; stat[1] – по статусу; atta[1] – по аттачментам, завирусованности;
 * ord[1] – по порядку получения;
 * extra_cond : дополнительное условие: строка ('only_new' или 'only_atta')
 * mesid : oracle'овый идентификатор сообщения от которого «плясать»
 * deviation: количество сообщений до mesid и после mesid, которое выдать
 * (максимальное количество выдаваемых сообщений 2*deviation+1)
 */
public class MailboxListNearestObj extends Obj {

    public static MailboxListNearestObj empty() {
        return new MailboxListNearestObj();
    }

    /**
     * @param ids мид центрального письма
     * @return
     */
    public MailboxListNearestObj setIds(String ids) {
        set("ids", ids);
        return this;
    }

    /**
     * Параметр для ручки ywmi
     * DARIA-52908
     * @param mid мид центрального письма
     * @return
     */
    public MailboxListNearestObj setMid(String mid) {
        set("mid", mid);
        return this;
    }

    /**
     * @param currentFolder - fid текущего фолдера
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setCurrentFolder(String currentFolder) {
        set("current_folder", currentFolder);
        return this;
    }

    /**
     * @param sortType
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setSetSortType(String sortType) {
        set("sort_type", sortType);
        return this;
    }

    public MailboxListNearestObj setSetSortTypeDate() {
        set("sort_type", "date");
        return this;
    }

    /**
     * Берется по умолчанию
     * @return
     */
    public MailboxListNearestObj setSetSortTypeDateDescending() {
        set("sort_type", "date_descending");
        return this;
    }

    public MailboxListNearestObj setSetSortTypeDateAscending() {
        set("sort_type", "date_ascending");
        return this;
    }


    /**
     * @param extraCond - кажется, не используется
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setExtraCond(String extraCond) {
        set("extra_cond", extraCond);
        return this;
    }

    /**
     * @param deviation - сколько писем хотят с каждой стороны
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setDeviation(String deviation) {
        set("deviation", deviation);
        return this;
    }

    /**
     * Параметр для ручки ywmi
     * DARIA-52908
     * @param uid
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    /**
     * Параметр для ручки ywmi
     * DARIA-52908
     * @param suid
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }


    /**
     * Параметр для ручки ywmi
     * DARIA-52908
     * @param mdb
     * @return MailboxListNearestObj
     */
    public MailboxListNearestObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }
}
