package ru.yandex.autotests.innerpochta.wmi.core.obj;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 27.03.12
 * Time: 18:49
 * <p/>
 * mailbox_oper: операции над письмами (удаление и перенос)
 * current_folder: текущий фолдер (id)
 * oper: операция – purge_spam, purge_trash, delete, move, tospam, anti_tospam, mark_read, mark_forwarder, mark_replied
 * для операций tospam, anti_tospam и mark'ов movefile и current_folder не нужны
 * movefile: фолдер для переноса писем
 * ids: массив id-писем для операций
 * fmids: массив fid'ов для писем (соответствующий по порядку)
 */
public class MailboxOperObj extends Obj {

    /**
     * Возвращает объект с настройками операций над письмами
     *
     * @return MailboxOperObj
     */
    public static MailboxOperObj empty() {
        return new MailboxOperObj();
    }

    /**
     * Перемещение указанного списка сообщений из папки from в папку where
     *
     * @param mids     - ArrayList - список мидов сообщений
     * @param whereFID - Фид папки куда перемещаем
     * @param fromFID  - Фид папки откуда перемещаем
     * @return MailboxOperObj
     */
    public static MailboxOperObj moveSomeMsges(List<String> mids, String whereFID, String fromFID) {
        return empty()
                .setOper(OPER_MOVE)
                .setIds(mids) // Что
                .setMovefile(whereFID) // Куда
                .setCurrentFolder(fromFID);
    }

    /**
     * Перемещение указанного списка сообщений из папки from в папку where
     *
     * @param tid      - ArrayList - список tid-ов сообщений
     * @param whereFID - Фид папки куда перемещаем
     * @param fromFID  - Фид папки откуда перемещаем
     * @return MailboxOperObj
     */
    public static MailboxOperObj moveSomeMsgesOnTid(String tid, String whereFID, String fromFID) {
        return empty()
                .setOper(OPER_MOVE)
                .setTids(tid) // Что
                .setMovefile(whereFID) // Куда
                .setCurrentFolder(fromFID);
    }

    /**
     * Перемещение указанного сообщения из папки from в папку where
     *
     * @param mid      - mid одного сообщения для перемещения
     * @param whereFID - Фид папки куда перемещаем
     * @param fromFID  - Фид папки откуда перемещаем
     * @return MailboxOperObj
     */
    public static MailboxOperObj moveOneMsg(String mid, String whereFID, String fromFID) {
        return empty()
                .setOper(OPER_MOVE)
                .addIds(mid) // Что (Отличие: add)
                .setMovefile(whereFID) // Куда
                .setCurrentFolder(fromFID);
    }

    /**
     * Удаление списка писем
     *
     * @param mids - список мидов писем для удаления
     * @return MailboxOperObj
     */
    public static MailboxOperObj deleteMsges(List<String> mids) {
        return empty()
                .setOper(OPER_DELETE)
                .setIds(mids);
    }

    /**
     * Удаление одного письма
     *
     * @param mid - мид письма для удаления
     * @return MailboxOperObj
     */
    public static MailboxOperObj deleteOneMsg(String mid) {
        return empty()
                .setOper(OPER_DELETE)
                .addIds(mid);
    }

    /**
     * Объект для пометки одного письма прочитанным
     *
     * @param mid - мид письма для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markReadOneMsg(String mid) {
        return empty()
                .setOper(OPER_MARKREAD)
                .addIds(mid);
    }

    /**
     * Объект для пометки писем прочитанным
     *
     * @param mids- миды писем для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markReadMsgs(List<String> mids) {
        return empty()
                .setOper(OPER_MARKREAD)
                .setIds(mids);
    }

    /**
     * Объект для пометки одного письма непрочитанным
     *
     * @param mid - мид письма для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markUNReadOneMsg(String mid) {
        return empty()
                .setOper(OPER_MARKUNREAD)
                .addIds(mid);
    }

    /**
     * Объект для пометки писем непрочитанным
     *
     * @param mids- миды писем для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markUNReadMsgs(List<String> mids) {
        return empty()
                .setOper(OPER_MARKUNREAD)
                .setIds(mids);
    }

    /**
     * Объект для пометки писем спамом
     *
     * @param mids- миды писем для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markSpamMsgs(List<String> mids) {
        return empty()
                .setOper(OPER_TOSPAM)
                .setIds(mids);
    }

    /**
     * Объект для пометки письма спамом
     *
     * @param mid- мид письма для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markSpamMsg(String mid) {
        return empty()
                .setOper(OPER_TOSPAM)
                .setIds(mid);
    }

    /**
     * Объект для пометки писем НЕспамом
     *
     * @param mids- миды писем для пометки
     * @return MailboxOperObj
     */
    public static MailboxOperObj markNOSpamMsgs(List<String> mids) {
        return empty()
                .setOper(OPER_NOSPAM)
                .setIds(mids);
    }

    /**
     * Добавляет mid в список для этой операции
     *
     * @param ids - mid письма
     * @return this
     */
    public MailboxOperObj addIds(String ids) {
        add("ids", ids);
        return this;
    }

    /**
     * Назначает список mid для этой операции
     *
     * @param ids - mid письма
     * @return this
     */
    public MailboxOperObj setIds(String ids) {
        remove("ids");
        add("ids", ids);
        return this;
    }


    /**
     * Добавляет tid в список для этой операции
     *
     * @param tid - tid письма
     * @return this
     */
    public MailboxOperObj addTids(String tid) {
        add("tids", tid);
        return this;
    }

    /**
     * Назначает список tid для этой операции
     *
     * @param tid - tid письма
     * @return this
     */
    public MailboxOperObj setTids(String tid) {
        remove("tids");
        add("tids", tid);
        return this;
    }

    /**
     * Назначает список mid для этой операции
     *
     * @param idsList - Список mid писем
     * @return this
     */
    public MailboxOperObj setIds(List<String> idsList) {
        remove("ids");
        add("ids", idsList.toArray(new String[idsList.size()]));
        return this;
    }

    /**
     * Очищает список подготовленных midов
     *
     * @return this
     */
    public MailboxOperObj clearIds() {
        remove("ids");
        return this;
    }

    /**
     * Назначает список fid'ов для этой операции (соответствующий по порядку)
     *
     * @param fmidsList - Список fid писем
     * @return this
     */
    public MailboxOperObj fmidsIds(List<String> fmidsList) {
        remove("fmids");
        add("fmids", fmidsList.toArray(new String[fmidsList.size()]));
        return this;
    }

    /**
     * массив fid'ов для писем (соответствующий по порядку)
     *
     * @param fmids - fid письма
     * @return this
     */
    public MailboxOperObj addFmids(String fmids) {
        add("fmids", fmids);
        return this;
    }

    public MailboxOperObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public MailboxOperObj setCkey(String ckey) {
        set("ckey", ckey);
        return this;
    }

    /**
     * Текущая папка
     *
     * @param currentFolderID FID текущей папки
     * @return this
     */
    public MailboxOperObj setCurrentFolder(String currentFolderID) {
        set("current_folder", currentFolderID);
        return this;
    }

    /**
     * @param movefile - фолдер для переноса писем
     * @return this
     */
    public MailboxOperObj setMovefile(String movefile) {
        set("movefile", movefile);
        return this;
    }


    /**
     * Выполняемая операция
     *
     * @param oper - операция
     *             Бывает: purge_spam, purge_trash, delete, move, tospam,
     *             anti_tospam, mark_read, mark_forwarder, mark_replied
     *             **для операций tospam, anti_tospam и mark'ов movefile и current_folder не нужны
     * @return this
     */
    public MailboxOperObj setOper(String oper) {
        set("oper", oper);
        return this;
    }

    //-----------------------------------------------------------------
    public static final String OPER_TOSPAM = "tospam";
    public static final String OPER_NOSPAM = "anti_tospam";
    public static final String OPER_PURGESPAM = "purge_spam";
    public static final String OPER_PURGETRASH = "purge_trash";
    public static final String OPER_DELETE = "delete";
    public static final String OPER_MOVE = "move";
    public static final String OPER_MARKREAD = "mark_read"; // в хендлерсах action=mark
    public static final String OPER_MARKUNREAD = "mark_not_read"; // в хендлерсах action=unmark
    public static final String OPER_MARKFWD = "mark_forwarder";
    public static final String OPER_MARKREPLY = "mark_replied";


    //-----------------------------------------------------------------


}
