package ru.yandex.autotests.innerpochta.wmi.core.obj;

import org.apache.log4j.LogManager;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 */
public class MessageByStidObj extends Obj {

    /**
     * о которому из монги достаются адресаты (ответ уходит отправителю исходного письма, а также всем, кто был в копии,
     * во фром пишется получатель исходного письма
     * (он всегда один), либо номер телефона при отсутствии адреса), проверяется счетчик ответов, таймстамп и проч.)
     *
     * @param hash - хеш письма вида
     *             ZS5hEwBHxrvREGsDVSOzYKZI9Umwum6PJ8QroWy1OmMLJCHcFNUlgd3glIy9Kwe2OcmaKPW7TXrJ5smRKKiRWg%3D%3D
     * @return this
     */
    public MessageByStidObj setHash(String hash) {
        LogManager.getLogger(this.getClass()).info("Encoded hash: " + hash);
        try {
            set("hash", URLDecoder.decode(hash, "UTF-8"));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public MessageByStidObj setHashAsIs(String hash) {
        LogManager.getLogger(this.getClass()).info("Encoded hash: " + hash);
        set("hash", hash);
        return this;
    }


    /* ------------------------------------------ */
    /* ------------Для ответа на смс письмо------ */
    /* ------------------------------------------ */

    /**
     * @param text - (тело письма, цитирование осуществляется неявным для нас образом, на фронтенде -
     *             нам придет уже готовый html, составленный версткой по шаблону,
     *             куда вставлена и цитата, и текст ответа)
     * @return this
     */
    public MessageByStidObj setText(String text) {
        set("text", text);
        return this;
    }


    /**
     * @param messageId - (идентификатор письма, на которое отвечаем, нужно для выставления заголовка In-Reply-To)
     * @return this
     */
    public MessageByStidObj setMessageId(String messageId) {
        set("message_id", messageId);
        return this;
    }


    /**
     * @param subject - (тема, к которой будет приписано Re)
     * @return this
     */
    public MessageByStidObj setSubject(String subject) {
        set("subject", subject);
        return this;
    }

    public MessageByStidObj setLang(String lang) {
        set("lang", lang);
        return this;
    }
}
