package ru.yandex.autotests.innerpochta.wmi.core.obj;

import com.google.common.base.Joiner;
import ru.yandex.autotests.innerpochta.beans.mdoby.Flag;

import static ru.yandex.autotests.innerpochta.beans.mdoby.Flag.SHOW_CONTENT_META;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Используется ручкой api/message
 */
public class MessageObj extends Obj {

    /**
     * Возвращает объект с настройками конкретного письма
     *
     * @return MessageObj
     */
    public static MessageObj getEmptyObj() {
        return new MessageObj();
    }

    /**
     * Возвращает объект, подготовленный для получения письма с заданным mid
     *
     * @param mid - заданный mid
     * @return MessageObj
     */
    public static MessageObj getMsg(String mid) {
        return getEmptyObj().setIds(mid);
    }

    /**
     * Возвращает объект, подготовленный для получения письма с заданным mid
     * и измененным тегом content для отображения содержимого
     *
     * @param mid - заданный mid
     * @return MessageObj
     */
    public static MessageObj getMsgWithContentFlag(String mid) {
        return getMsg(mid).setFlags(SHOW_CONTENT_META);
    }

    /**
     * идентификатор письма для просмотра
     *
     * @param ids - mid письма
     * @return MessageObj
     */
    public MessageObj setIds(String ids) {
        set("ids", ids);
        return this;
    }

    /**
     * Пометка спамом, добавляет к запросу &is_spam
     *
     * @return MessageObj
     */
    public MessageObj setIsSpam() {
        set("is_spam", "1");
        return this;
    }

    /**
     * Устанавливаем идентификатор для просмотра встроенных писем
     * @param hid
     * @return
     */
    public MessageObj setHid(String hid) {
        set("hid", hid);
        return this;
    }

    /**
     * Устанавливаем локаль пользователя
     * @param lang
     * @return
     */
    public MessageObj setLang(String lang) {
        set("lang", lang);
        return this;
    }

    /**
     * Назначает особый флаг для письма
     * Пока другие флаги неизвестны, но возможны
     * При появлении переделать в список
     *
     * @param flags - флаг
     * @return MessageObj
     */
    public MessageObj setFlags(Flag... flags) {
        set("flags", Joiner.on(",").join(flags));
        return this;
    }
}
