package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Используется ручкой api/message
 */
public class MessagePartObj extends Obj {

    /**
     * Возвращает объект с настройками конкретного письма
     *
     * @return MessageObj
     */
    public static MessagePartObj getEmptyObj() {
        return new MessagePartObj();
    }

    /**
     * Возвращает объект, подготовленный для получения письма с заданным mid
     *
     * @param mid      - заданный mid
     * @param hid      - мулечный id части письма
     * @param fileName - имя аттача
     * @return MessagePartObj
     */
    public static MessagePartObj getUrlObj(String mid, String hid, String fileName) {
        return getEmptyObj().setIds(mid).setHid(hid).setName(fileName);
    }

    /**
     * идентификатор письма для просмотра
     *
     * @param ids - mid письма
     * @return this
     */
    public MessagePartObj setIds(String ids) {
        set("ids", ids);
        return this;
    }


    /**
     * @param hid мулечный id части письма
     * @return this
     */
    public MessagePartObj setHid(String hid) {
        set("hid", hid);
        return this;
    }

    /**
     * @param name имя аттача
     * @return this
     */
    public MessagePartObj setName(String name) {
        set("name", name);
        return this;
    }

    /**
     * DARIA-40987
     * доп. параметр для получения превьюшки офисного дока
     * @return this
     */
    public MessagePartObj setPreview() {
        set("preview", "y");
        return this;
    }

    /**
     * DARIA-40987
     * доп. параметр верстка по идее должны прокидывать в message_part_real
     */
    public MessagePartObj setThumb(String thumb) {
        set("thumb", thumb);
        return this;
    }
}
