package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Используется ручкой получения сорцов письма
 */
public class MessageSourceObj extends Obj {

    /**
     * Возвращает объект с настройками для получения сорцов письма
     *
     * @return MessageSourceObj
     */
    public static MessageSourceObj empty() {
        MessageSourceObj obj = new MessageSourceObj();
        return obj;
    }

    /**
     * Подготавливает объект для получения ответа по известному ids
     *
     * @param mid - стандартный mid письма
     * @return MessageSourceObj
     */
    public static MessageSourceObj getSourceByMid(String mid) {
        return empty().setMid(mid);
    }

    /**
     * @param mid - Mid письма вида: 3210.0.232260869292504935728358977497
     * @return this
     */
    public MessageSourceObj setMid(String mid) {
        set("mid", mid);
        return this;
    }
}
