package ru.yandex.autotests.innerpochta.wmi.core.obj;

import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 27.03.12
 * Time: 18:49
 * <p/>
 * ids: массив id-писем для операций
 * lid - ид метки
 */
public class MessageToLabelUnlabelObj extends Obj {

    /**
     * Возвращает объект с настройками пометки или снятия метки с писем
     *
     * @return MessageToLabelUnlabelObj
     */
    public static MessageToLabelUnlabelObj getEmptyObj() {
        return new MessageToLabelUnlabelObj();
    }

    /**
     * Чтобы пометить сразу массив писем меткой
     *
     * @param mids - список мидов писем
     * @param lid  - id метки
     * @return MessageToLabelUnlabelObj
     */
    public static MessageToLabelUnlabelObj labelMessages(List<String> mids, String lid) {
        return getEmptyObj()
                .setIds(mids) // Что
                .setLid(lid);
    }

    /**
     * Чтобы пометить сразу все письма по tid-у
     *
     * @param tids - tid писем для пометки
     * @param lid  - id метки
     * @return MessageToLabelUnlabelObj
     */
    public static MessageToLabelUnlabelObj labelThread(String tids, String lid) {
        return getEmptyObj()
                .setTids(tids) // Что
                .setLid(lid);
    }

    /**
     * Чтобы пометить письмо меткой
     *
     * @param mid - мид письма для пометки
     * @param lid - ид метки
     * @return MessageToLabelUnlabelObj
     */
    public static MessageToLabelUnlabelObj labelOne(String mid, String lid) {
        return getEmptyObj()
                .addIds(mid) // Что (Отличие: add)
                .setLid(lid);
    }

    /**
     * Добавляет mid в список для этой операции
     *
     * @param ids - mid письма
     * @return this
     */
    public MessageToLabelUnlabelObj addIds(String ids) {
        add("ids", ids);
        return this;
    }

    /**
     * Назначает список mid для этой операции
     *
     * @param idsList - Список mid писем
     * @return this
     */
    public MessageToLabelUnlabelObj setIds(List<String> idsList) {
        remove("ids");
        add("ids", idsList.toArray(new String[idsList.size()]));
        return this;
    }

    /**
     * Очищает список подготовленных midов
     *
     * @return this
     */
    public MessageToLabelUnlabelObj clearIds() {
        remove("ids");
        return this;
    }

    /**
     * Назначение метки
     *
     * @param lid id метки
     * @return this
     */
    public MessageToLabelUnlabelObj setLid(String lid) {
        set("lid", lid);
        return this;
    }

    public MessageToLabelUnlabelObj setTids(String tids) {
        set("tids", tids);
        return this;
    }
}
