package ru.yandex.autotests.innerpochta.wmi.core.obj;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 12:01
 */
public class PagerMailboxListObj extends MailBoxListObj {

    /**
     * @param from - начиная с какой даты
     *             Дата в формате HH:mm:ss dd.MM.yyyy
     *             Письма, дата получения которых равна указанной дате, в выдачу не попадают
     *             по причине строгой (>,<) фильтрации
     * @return this
     */
    public PagerMailboxListObj setFrom(String from) {
        set("from", from);
        return this;
    }

    public PagerMailboxListObj setFrom(Date from) {
        set("from", new SimpleDateFormat("HH:mm:ss dd.MM.yyyy").format(from));
        return this;
    }


    /**
     * @param to - по какую дату
     *           Дата в формате HH:mm:ss dd.MM.yyyy
     *           Письма, дата получения которых равна указанной дате, в выдачу не попадают
     *           по причине строгой (>,<) фильтрации
     * @return this
     */
    public PagerMailboxListObj setTo(String to) {
        set("to", to);
        return this;
    }

    public PagerMailboxListObj setTo(Date to) {
        set("to", new SimpleDateFormat("HH:mm:ss dd.MM.yyyy").format(to));
        return this;
    }


    /**
     * @param pageNumber - номер страницы
     * @return this
     */
    @Override
    public PagerMailboxListObj setPageNumber(String pageNumber) {
        super.setPageNumber(pageNumber);
        return this;
    }

    @Override
    public PagerMailboxListObj setPageNumber(Integer pageNumber) {
        super.setPageNumber(pageNumber);
        return this;
    }

    /**
     * @param currentFolderFID - текущая папка, fid
     * @return this
     */
    @Override
    public PagerMailboxListObj setCurrentFolder(String currentFolderFID) {
        super.setCurrentFolder(currentFolderFID);
        return this;
    }


    /**
     * @param sortType - поле сортировки
     *                 Бывает: строка (subj[1] по теме – [1] по возрастанию; from[1] – по отправителю;
     *                 date[1] – по дате; size[1] – по размеру; stat[1] – по статусу;
     *                 atta[1] – по аттачментам, завирусованности; ord[1] – по порядку получения;
     * @return this
     */
    @Override
    public PagerMailboxListObj setSortType(String sortType) {
        super.setSortType(sortType);
        return this;
    }


    /**
     * @param goTo - в какой папке смотрим
     *             Бывает: (spam,sent,draft,inbox)
     * @return this
     */
    @Override
    public PagerMailboxListObj setGoto(String goTo) {
        super.setGoto(goTo);
        return this;
    }

    /**
     * @param extraCond - отбор по доп условиям
     *                  Бывает: строка ('only_new' или 'only_atta')
     *                  С пейджером данный параметр игнорируется
     * @return this
     */
    @Override
    public PagerMailboxListObj setExtraCond(String extraCond) {
        super.setExtraCond(extraCond);
        return this;
    }

    /**
     * @param currentLabel: lid текущей метки (имеет больший приоритет, чем current_folder или goto)
     * @return this
     */
    @Override
    public PagerMailboxListObj setCurrentLabel(String currentLabel) {
        super.setCurrentLabel(currentLabel);
        return this;
    }


}
