package ru.yandex.autotests.innerpochta.wmi.core.obj;

import org.hamcrest.Factory;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 */
public class SearchObj extends Obj {
    /**
     * @return SettingsFolderDeleteObj
     */
    public static SearchObj emptySearchParams() {
        return new SearchObj();
    }

    /**
     * Поиск чего то
     *
     * @param request - запрос для поиска
     * @return SearchObj
     */
    public static SearchObj search(String request) {
        return emptySearchParams().setRequest(request);
    }


    /**
     * Назначает запрос для поиска
     *
     * @param request - Запрос
     * @return this
     */
    public SearchObj setRequest(String request) {
        set("request", request);
        return this;
    }

    public SearchObj setMid(String mid) {
        set("mid", mid);
        return this;
    }


    public SearchObj fid(String fid) {
        set("fid", fid);
        return this;
    }

    public SearchObj setMsgLimit(String msgLimit) {
        set("msg_limit", msgLimit);
        return this;
    }

    public SearchObj setHistory(String history) {
        set("history", history);
        return this;
    }

    public SearchObj setSubject(String subject) {
        set("subject", subject);
        return this;
    }

    public SearchObj setAddr(String addr) {
        set("addr", addr);
        return this;
    }

    public SearchObj setExcluded(String excluded) {
        set("excluded", excluded);
        return this;
    }

    public SearchObj setSearchScope(String searchScope) {
        set("search_scope", searchScope);
        return this;
    }

    public SearchObj setThreadLimit(String threadLimit) {
        set("thread_limit", threadLimit);
        return this;
    }

    public SearchObj setFirst(String first) {
        set("first", first);
        return this;
    }

    public SearchObj setLast(String last) {
        set("last", last);
        return this;
    }

    public SearchObj setCount(String count) {
        set("count", count);
        return this;
    }

    public SearchObj setPageNumber(String pageNumber) {
        set("page_number", pageNumber);
        return this;
    }


    public static final String HISTORY_LINKS = "links";
    public static final String HISTORY_MAIL = "mail";
    public static final String HISTORY_ATTACHMENTS = "attachments";

    @Factory
    public static SearchObj getAttaches(String mid, String request) {
        return new SearchObj().setMsgLimit("21").setRequest(request).setMid(mid)
                .setHistory(SearchObj.HISTORY_ATTACHMENTS);
    }

    @Factory
    public static SearchObj getMsg(String mid, String request) {
        return new SearchObj().setMsgLimit("21").setRequest(request).setMid(mid)
                .setHistory(SearchObj.HISTORY_MAIL);
    }

    @Factory
    public static SearchObj getLinks(String mid, String request) {
        return new SearchObj().setMsgLimit("21").setRequest(request).setMid(mid)
                .setHistory(SearchObj.HISTORY_LINKS);
    }

    @Factory
    public static SearchObj history(String history) {
        return new SearchObj().setHistory(history);
    }

    public SearchObj addMidRequest(String mid, String request) {
        return setMsgLimit("21").setRequest(request).setMid(mid);
    }

}
