package ru.yandex.autotests.innerpochta.wmi.core.obj;

import static com.google.common.base.Joiner.on;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 */
public class SettingsApiObj extends Obj {


    public static final String SEPARATOR = "%0d";

    public SettingsApiObj mdb(String mdb) {
        set(true, "mdb", mdb);
        return this;
    }


    public SettingsApiObj suid(String suid) {
        set(true, "suid", suid);
        return this;
    }

    public SettingsApiObj uid(String uid) {
        set(true, "uid", uid);
        return this;
    }

    /**
     * @param settings CSV с именами настроек, которые необходимо вернуть.
     *                 В качестве разделителя используется символ '\r' (он же CR, он же %0d)
     * @return
     */
    public SettingsApiObj settingsList(String... settings) {
        set(true, "settings_list", on(SEPARATOR).join(settings));
        return this;
    }

    public SettingsApiObj format(String jsonXml) {
        set(true, "format", jsonXml);
        return this;
    }

    public SettingsApiObj json() {
        return format("json");
    }


    public SettingsApiObj askValidator() {
        set(true, "ask_validator", "y");
        return this;
    }

    public static SettingsApiObj settings(String uid) {
        return new SettingsApiObj().uid(uid).format("xml");
    }

    public static SettingsApiObj withUid(String uid) {
        return new SettingsApiObj().uid(uid);
    }
    public static SettingsApiObj withSuid(String suid) {
        return new SettingsApiObj().suid(suid);
    }


}
