package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * settings_folder_clear
 * <p/>
 * <p/>
 * fid : id папки
 * method : строка(«clear»|"purge"|"clearSelected"), удалить в удаленные, удалить совсем, удалить по критериям
 * old_f : integer, старше чем столько дней
 * from_f : строка, адрес содержит
 * subj_f : строка, тема содержит
 */
public class SettingsFolderClearObj extends Obj {

    /**
     * Возвращает объект с настройками для очистки папки
     *
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj getEmptyObj() {
        return new SettingsFolderClearObj();
    }

    /**
     * Полная очистка папки
     *
     * @param fid - фид папки
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj purgeFid(String fid) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_PURGE);
    }


    /**
     * Помечаем письма в папке прочитанными
     *
     * @param fid - фид папки
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj markRead(String fid) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_MARK_READ);
    }

    /**
     * Удаление в удаленные (мягкая чистка)
     *
     * @param fid - фид папки
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj clearFid(String fid) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_CLEAR);
    }

    /**
     * Объект для чистки папки от писем с определнной темой
     *
     * @param fid  - фид папки
     * @param subj - тема для удаления
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj clearBySubj(String fid, String subj) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_CLEARSELECTED).setSubjF(subj);
    }

    /**
     * Объект для чистки папки от писем с определнным отправителем
     *
     * @param fid  - фид папки
     * @param from - отправитель
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj getObjToClearByFrom(String fid, String from) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_CLEARSELECTED).setFromF(from);
    }

    /**
     * Объект для чистки папки от писем старше скольких то дней
     *
     * @param fid - фид папки
     * @param old - старше чего
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj getObjToClearByOld(String fid, String old) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_CLEARSELECTED).setOldF(old);
    }

    /**
     * Объект для чистки папки от писем старше скольких то дней
     *
     * @param fid - фид папки
     * @param old - старше чего
     * @return SettingsFolderClearObj
     */
    public static SettingsFolderClearObj getObjToClearByOld(String fid, Integer old) {
        return getEmptyObj().setFid(fid).setMethod(METHOD_CLEARSELECTED).setOldF(old);
    }

    /**
     * идентификатор фолдера,
     * у данного фолдера в списке
     * выставляется аттрибут current в 'yes'
     *
     * @param fid - id папки
     * @return this
     */
    public SettingsFolderClearObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param method строка(«clear»|"purge"|"clearSelected"),
     *               удалить в удаленные, удалить совсем, удалить по критериям
     * @return this
     */
    public SettingsFolderClearObj setMethod(String method) {
        set("method", method);
        return this;
    }

    //-----------------------------------------------------------
    public static final String METHOD_CLEAR = "clear";                  // удалить в удаленные
    public static final String METHOD_PURGE = "purge";
    public static final String METHOD_MARK_READ = "mark_read";          // помечаем прочитанными
    public static final String METHOD_CLEARSELECTED = "clearSelected";  // удалить по критериям
    //-----------------------------------------------------------


    /**
     * @param oldF - string, старше чем столько дней
     * @return this
     */
    public SettingsFolderClearObj setOldF(String oldF) {
        add("old_f", oldF);
        return this;
    }

    /**
     * @param oldF - integer, старше чем столько дней
     * @return this
     */
    public SettingsFolderClearObj setOldF(Integer oldF) {
        return setOldF(oldF.toString());
    }

    /**
     * @param fromF - строка, адрес содержит
     * @return this
     */
    public SettingsFolderClearObj setFromF(String fromF) {
        set("from_f", fromF);
        return this;
    }

    /**
     * @param subjF - subj_f : строка, тема содержит
     * @return this
     */
    public SettingsFolderClearObj setSubjF(String subjF) {
        set("subj_f", subjF);
        return this;
    }


}
