package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * settings_folder_create
 * folder_name : строка(«A-Za-z0–9._@*" и все что больше 127; 32 символа максимум), имя папки
 * (Можно создать папку с именем сердечко) :)
 */
public class SettingsFolderCreateObj extends Obj {

    /**
     * @return SettingsFolderCreateObj
     */
    public static SettingsFolderCreateObj empty() {
        return new SettingsFolderCreateObj();
    }

    /**
     * Получает объект с указанным именем
     *
     * @param folderName - имя папки папки
     * @return SettingsFolderCreateObj
     */
    public static SettingsFolderCreateObj newFolder(String folderName) {
        return empty().setFolderName(folderName);
    }

    /**
     * Получает объект с указанным именем
     * для создания подпапки
     *
     * @param folderName - имя папки папки
     * @param parentFID  - фид родительской папки
     * @return SettingsFolderCreateObj
     */
    public static SettingsFolderCreateObj newChildFolder(String folderName, String parentFID) {
        return newFolder(folderName).setParentId(parentFID);
    }

    /**
     * @param folderName - строка(«A-Za-z0–9._@*" и все что больше 127; 32 символа максимум), имя папки
     * @return this
     */
    public SettingsFolderCreateObj setFolderName(String folderName) {
        set("folder_name", folderName);
        return this;
    }

    /**
     * @param parentId - фид папки-родителя
     * @return this
     */
    public SettingsFolderCreateObj setParentId(String parentId) {
        set("parent_id", parentId);
        return this;
    }
}
