package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * settings_folder_clear
 * <p/>
 * <p/>
 * fid : id папки
 * method : строка(«clear»|"purge"|"clearSelected"), удалить в удаленные, удалить совсем, удалить по критериям
 * old_f : integer, старше чем столько дней
 * from_f : строка, адрес содержит
 * subj_f : строка, тема содержит
 */
public class SettingsFolderDeleteObj extends Obj {

    /**
     * @return SettingsFolderDeleteObj
     */
    public static SettingsFolderDeleteObj empty() {
        return new SettingsFolderDeleteObj();
    }

    /**
     * Чтобы удалить одну папку
     *
     * @param fid - фид папки
     * @return SettingsFolderDeleteObj
     */
    public static SettingsFolderDeleteObj deleteOneFolder(String fid) {
        return empty().setFid(fid);
    }

    /**
     * идентификатор фолдера,
     *
     * @param fid - id папки
     * @return this
     */
    public SettingsFolderDeleteObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * Удалить папку вместе с сообщениями
     *
     * @param force - бывает yes и no - удалять ли папку, если в ней есть сообщения
     * @return this
     */
    public SettingsFolderDeleteObj setForce(String force) {
        set("force", force);
        return this;
    }

}
