package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 7/8/13
 * Time: 6:54 PM
 */
public class SettingsFolderMoveObj extends Obj {

    /**
     * @return SettingsFolderMoveObj
     */
    public static SettingsFolderMoveObj move() {
        return new SettingsFolderMoveObj();
    }

    /**
     * Возвращает объект для переноса папки с заданным фидом
     * в папку с заданным фидом
     *
     * @param fid       - фид папки, которую переносим
     * @param parentFid - фид папки, под которую переносим
     * @return SettingsFolderRenameObj
     */
    public static SettingsFolderMoveObj move(String fid, String parentFid) {
        return move().setFid(fid).setParentFid(parentFid);
    }

    /**
     * @param fid - id папки
     * @return this
     */
    public SettingsFolderMoveObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param parentFid - фид папки, под которую переносим
     * @return SettingsFolderRenameObj
     */
    public SettingsFolderMoveObj setParentFid(String parentFid) {
        set("parent_id", parentFid);
        return this;
    }

    /**
     * DARIA-49596
     * @param connectionId connection_id
     */
    public SettingsFolderMoveObj setConnectionId(String connectionId) {
        set("connection_id", connectionId);
        return this;
    }
}
