package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Для переименования папки
 */
public class SettingsFolderRenameObj extends Obj {

    /**
     * Возвращает объект готовый к назначению настройки
     *
     * @return SettingsFolderRenameObj
     */
    public static SettingsFolderRenameObj getEmptyObj() {
        return new SettingsFolderRenameObj();
    }

    /**
     * Возвращает объект для переименования папки с заданным фидом в новое имя
     *
     * @param fid     - фид папки для переименования
     * @param newName - новое имя папки
     * @return SettingsFolderRenameObj
     */
    public static SettingsFolderRenameObj getObjToRename(String fid, String newName) {
        return getEmptyObj().setFid(fid).setFname(newName);
    }

    /**
     * идентификатор фолдера,
     *
     * @param fid - id папки
     * @return SettingsFolderRenameObj
     */
    public SettingsFolderRenameObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param fname - новое имя папки
     * @return SettingsFolderRenameObj
     */
    public SettingsFolderRenameObj setFname(String fname) {
        set("fname", fname);
        return this;
    }

}
