package ru.yandex.autotests.innerpochta.wmi.core.obj;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * settings_folder_set_options
 * <p/>
 * <p/>
 * WMI-103
 * Устанавливает опции внутри тега
 * <folder_options>{"threaded": "?","notify": "1"}</folder_options>
 * передавать нужно все опции, даже если меняется одна
 * пример запроса: simple.jsx?wmi-method=settings_folder_set_options&fid=<fid>&threaded=?&notify=1
 * [@]param params fid, notify, threaded и другие, если появятся
 * <p/>
 * Если будут новые настройки, обновить фабрику объекта
 */
public class SettingsFolderSetOptionsObj extends Obj {

    /**
     * Возвращает объект готовый к назначению настроек для папки
     *
     * @return SettingsFolderSetOptionsObj
     */
    public static SettingsFolderSetOptionsObj empty() {
        return new SettingsFolderSetOptionsObj();
    }

    /**
     * Создает объект для назначения всех известных настроек определенной папке
     *
     * @param fid      - фид папки, которой назначаем настройку
     * @param notify   - за описанием свойства в объект
     * @param threaded - аналогично
     * @return SettingsFolderSetOptionsObj
     */
    public static SettingsFolderSetOptionsObj setAllOptions(String fid, String notify, String threaded) {
        return empty().setFid(fid).setNotify(notify).setThreaded(threaded);
    }

    /**
     * идентификатор фолдера,
     * у данного фолдера в списке
     * собственно и меняются настройки
     *
     * @param fid - id папки
     * @return SettingsFolderSetOptionsObj
     */
    public SettingsFolderSetOptionsObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * Судя по названию - выводить папку с группировкой писем по теме. Но это лишь догадки
     *
     * @param threaded бывает ?, 1 и 0
     * @return this
     */
    public SettingsFolderSetOptionsObj setThreaded(String threaded) {
        set("threaded", threaded);
        return this;
    }

    /**
     * Назначение параметра необходимо узнать в WMI-103
     *
     * @param notify бывает ?, 1 и 0
     * @return this
     */
    public SettingsFolderSetOptionsObj setNotify(String notify) {
        set("notify", notify);
        return this;
    }

    /**
     * Возвращает Obj как JSON объект
     *
     * @return JSON объект
     */
    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        for (String key : params.keySet()) {
            try {
                obj.put(key, getParam(key));
            } catch (JSONException e) {
                throw new RuntimeException("", e);
            }
        }
        return obj;
    }

    /**
     * DARIA-1690
     * Создает объект для сортировки
     *
     * @param fid      - фид папки, позицию которой надо изменить
     * @param prev     - фид папки, ПОСЛЕ которой надо расположить папку, позицию которой мы меняем, либо 0 в случае,
     *                 если папку необходимо расположить первой в списке
     * @param notify   - за описанием свойства в объект
     * @param threaded - аналогично
     * @return SettingsFolderSetOptionsObj
     */
    public SettingsFolderSetOptionsObj setSortOptions(String fid, String prev, String notify, String threaded) {
        return empty().setFid(fid).setPrev(prev).setNotify(notify).setThreaded(threaded);
    }

    /**
     * Фид папки,за которой нужно расположить папку
     *
     * @param prev - fid фолдера
     * @return SettingsFolderSetOptionsObj
     */
    public SettingsFolderSetOptionsObj setPrev(String prev) {
        set("prev", prev);
        return this;
    }
}
