package ru.yandex.autotests.innerpochta.wmi.core.obj;

import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Можно использовать с ручками folder_list и folder_list_nodefault
 * А так же: mark_folder_seen (Наследник этого класса - при добавлении других свойств прочитать нотис в наследнике)
 */
public class SettingsFolderSymbolObj extends Obj {


    public static SettingsFolderSymbolObj fid(String fid) {
        return new SettingsFolderSymbolObj().setFid(fid);
    }


    public static SettingsFolderSymbolObj symbolOn(String fid, String symbol) {
        return fid(fid).setSymbol(symbol);
    }

    /**
     * @param fid - id папки
     */
    public SettingsFolderSymbolObj setFid(String fid) {
        set("fid", fid);
        return this;
    }


    /**
     * @param symbol - (archive,template,discount)
     */
    public SettingsFolderSymbolObj setSymbol(String symbol) {
        set("symbol", symbol);
        return this;
    }

    public enum Symbols {
        UNKNOWN(Symbol.UNKNOWN_TEST_SYMBOL, "0"),
        ARCHIVE(Symbol.ARCHIVE, "7"),
        TEMPLATE(Symbol.TEMPLATE, "8"),
        DISCOUNT(Symbol.DISCOUNT, "9");


        private String value;
        private String special;

        Symbols(Symbol value, String special) {
            this.value = value.toString();
            this.special = special;
        }

        public String value() {
            return value;
        }

        public String special() {
            return special;
        }
    }

}
