package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * settings_label_create
 */
public class SettingsLabelCreateObj extends Obj {

    /**
     * Возвращает объект для создания метки
     *
     * @return SettingsLabelCreateObj
     */
    public static SettingsLabelCreateObj empty() {
        return new SettingsLabelCreateObj();
    }

    /**
     * Подготавливает объект для создания новой метки
     * дефолтного цвета с заданным именем
     *
     * @param labelName - имя метки
     * @return SettingsLabelCreateObj
     */
    public static SettingsLabelCreateObj newLabel(String labelName) {
        return empty().setLabelColor(COLOR_CYAN).setLabelName(labelName);
    }

    /**
     * @param labelName - строка(«A-Za-z0–9._@*" и все что больше 127; 32 символа максимум), имя метки
     * @return this
     */
    public SettingsLabelCreateObj setLabelName(String labelName) {
        set("label_name", labelName);
        return this;
    }

    /**
     * @param labelColor - Числовой цвет метки
     * @return this
     */
    public SettingsLabelCreateObj setLabelColor(String labelColor) {
        set("label_color", labelColor);
        return this;
    }

    //----------------------------------------------------------
    public static final String COLOR_CYAN = "3126463";
    //----------------------------------------------------------

    /**
     * @param ckey - достается из аккаунт информейшн
     * @return this
     */
    public SettingsLabelCreateObj setCkey(String ckey) {
        set("ckey", ckey);
        return this;
    }
}
