package ru.yandex.autotests.innerpochta.wmi.core.obj;

import com.google.common.base.Joiner;

import static com.google.common.collect.Lists.newArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 */
public class SettingsLabelDeleteObj extends Obj {
    /**
     * @return SettingsLabelDeleteObj
     */
    public static SettingsLabelDeleteObj getEmptyObj() {
        return new SettingsLabelDeleteObj();
    }

    /**
     * Чтобы удалить одну метку
     *
     * @param lid - лид метки
     * @return SettingsLabelDeleteObj
     */
    public static SettingsLabelDeleteObj oneLid(String lid) {
        return getEmptyObj().setLids(lid).setForce("no");
    }

    /**
     * Назначает lid для этой операции
     *
     * @param lids - Метка
     * @return this
     */
    public SettingsLabelDeleteObj setLids(String lids) {
        set("lids", lids);
        return this;
    }

    /**
     * Назначает lid для этой операции
     *
     * @param lids - Метка
     * @return this
     */
    public static SettingsLabelDeleteObj lids(String... lids) {
        return getEmptyObj().setLids(Joiner.on(",").join(newArrayList(lids))).setForce("no");
    }

    /**
     * Назначает force удаление метки
     * Может быть yes, no
     * Удаляет метку вместе с фильтром и даже в том случае, если есть помеченные письма
     *
     * @param force - Параметр удаления
     * @return this
     */
    public SettingsLabelDeleteObj setForce(String force) {
        set("force", force);
        return this;
    }

}
