package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * settings_label_create
 */
public class SettingsLabelRenameObj extends Obj {
    /**
     * @return SettingsLabelRenameObj
     */
    public static SettingsLabelRenameObj getEmptyObj() {
        return new SettingsLabelRenameObj();
    }

    /**
     * Чтобы изменить одну метку
     *
     * @param lid           - лид метки
     * @param newLabelColor - новое имя
     * @param newLabelName  - новый цвет
     *
     * @return SettingsLabelRenameObj
     */
    public static SettingsLabelRenameObj renameOneLabelObj(String lid, String newLabelName, String newLabelColor) {
        return getEmptyObj()
                .setLid(lid)
                .setLabelName(newLabelName)
                .setLabelColor(newLabelColor);
    }

    public static SettingsLabelRenameObj renameLabelObj(String lid, String newLabelName) {
        return getEmptyObj()
                .setLid(lid)
                .setLabelName(newLabelName);
    }

    /**
     * @param labelName - строка(«A-Za-z0–9._@*" и все что больше 127; 32 символа максимум), имя метки
     *
     * @return this
     */
    public SettingsLabelRenameObj setLabelName(String labelName) {
        set("label_name", labelName);
        return this;
    }

    /**
     * @param labelColor - Числовой цвет метки
     *
     * @return this
     */
    public SettingsLabelRenameObj setLabelColor(String labelColor) {
        set("label_color", labelColor);
        return this;
    }

    /**
     * Назначает lid для этой операции
     *
     * @param lid - Метка
     *
     * @return this
     */
    public SettingsLabelRenameObj setLid(String lid) {
        set("lid", lid);
        return this;
    }

}
