package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * server
 * login
 * password
 * port
 * use_ssl
 * email
 * no_delete_msg
 * abook_sync
 * mark_old_as_read
 */
public class SettingsRpopperCreateObj extends Obj {

    /**
     * Возвращает объект готовый к назначению настроек для папки
     *
     * @return SettingsRpopperCreateObj
     */
    public static SettingsRpopperCreateObj rpop() {
        return new SettingsRpopperCreateObj();
    }

    /**
     * @param server - строка, поп-сервер
     * @return this
     */
    public SettingsRpopperCreateObj setServer(String server) {
        set("server", server);
        return this;
    }

    public String getServer() {
        return getParam("server");
    }


    /**
     * @param email - строка, мыло
     * @return this
     */
    public SettingsRpopperCreateObj setEmail(String email) {
        set("email", email);
        return this;
    }


    public String getEmail() {
        return getParam("email");
    }

    /**
     * @param login - строка, логин пользователя. Часто совпадает с email
     * @return this
     */
    public SettingsRpopperCreateObj setLogin(String login) {
        set("login", login);
        return this;
    }


    public String getLogin() {
        return getParam("login");
    }


    /**
     * @param password - строка, пароль пользователя
     * @return this
     */
    public SettingsRpopperCreateObj setPassword(String password) {
        set("password", password);
        return this;
    }


    public String getPassword() {
        return getParam("password");
    }


    /**
     * @param port - строка, порт подключения к серверу поп
     *             обычно 110 или 995 при безопасном подключении
     * @return this
     */
    public SettingsRpopperCreateObj setPort(String port) {
        set("port", port);
        return this;
    }


    public String getPort() {
        return getParam("port");
    }


    /**
     * @param useSsl - bool(on|off), использовать ли безопасное шифрованое соединение
     *               при использовании не забыть указать безопасный порт
     * @return this
     */
    public SettingsRpopperCreateObj setUseSsl(String useSsl) {
        set("use_ssl", useSsl);
        return this;
    }


    public String getUseSsl() {
        return getParam("use_ssl");
    }


    /**
     * @param noDeleteMsg
     * @return this
     */
    public SettingsRpopperCreateObj setNoDeleteMsg(String noDeleteMsg) {
        set("no_delete_msg", noDeleteMsg);
        return this;
    }


    public String getNoDeleteMsg() {
        return getParam("no_delete_msg");
    }


    /**
     * @param abookSync
     * @return this
     */
    public SettingsRpopperCreateObj setAbookSync(String abookSync) {
        set("abook_sync", abookSync);
        return this;
    }


    public String getAbookSync() {
        return getParam("abook_sync");
    }


    /**
     * @param markOldAsRead
     * @return this
     */
    public SettingsRpopperCreateObj setMarkOldAsRead(String markOldAsRead) {
        set("mark_old_as_read", markOldAsRead);
        return this;
    }


    public String getMarkOldAsRead() {
        return getParam("mark_old_as_read");
    }


}