package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Смотреть все свойства в объекте-родителе
 */
public class SettingsRpopperEditObj extends SettingsRpopperCreateObj {

    /**
     * Возвращает объект готовый к назначению настроек
     *
     * @return SettingsRpopperEditObj
     */
    public static SettingsRpopperEditObj getEmptyObj() {
        return new SettingsRpopperEditObj();
    }

    /**
     * @param popid - строка, ID сборщика для редактирования
     * @return this
     */
    public SettingsRpopperEditObj setPopid(String popid) {
        set("popid", popid);
        return this;
    }


    /**
     * @param server - строка, поп-сервер
     * @return this
     */
    public SettingsRpopperEditObj setServer(String server) {
        super.setServer(server);
        return this;
    }

    /**
     * @param email - строка, мыло
     * @return this
     */
    public SettingsRpopperEditObj setEmail(String email) {
        super.setEmail(email);
        return this;
    }

    /**
     * @param login - строка, логин пользователя. Часто совпадает с email
     * @return this
     */
    public SettingsRpopperEditObj setLogin(String login) {
        super.setLogin(login);
        return this;
    }


    /**
     * @param password - строка, пароль пользователя
     * @return this
     */
    public SettingsRpopperEditObj setPassword(String password) {
        super.setPassword(password);
        return this;
    }


    /**
     * @param port - строка, порт подключения к серверу поп
     *             обычно 110 или 995 при безопасном подключении
     * @return this
     */
    public SettingsRpopperEditObj setPort(String port) {
        super.setPort(port);
        return this;
    }


    /**
     * @param useSsl - bool(on|off), использовать ли безопасное шифрованое соединение
     *               при использовании не забыть указать безопасный порт
     * @return this
     */
    public SettingsRpopperEditObj setUseSsl(String useSsl) {
        super.setUseSsl(useSsl);
        return this;
    }

    /**
     * @param noDeleteMsg
     * @return this
     */
    public SettingsRpopperEditObj setNoDeleteMsg(String noDeleteMsg) {
        super.setNoDeleteMsg(noDeleteMsg);
        return this;
    }


    /**
     * @param abookSync
     * @return this
     */
    public SettingsRpopperEditObj setAbookSync(String abookSync) {
        super.setAbookSync(abookSync);
        return this;
    }

    /**
     * @param markOldAsRead
     * @return this
     */
    public SettingsRpopperEditObj setMarkOldAsRead(String markOldAsRead) {
        super.setMarkOldAsRead(markOldAsRead);
        return this;
    }

    public String getPopid() {
       return getParam("popid");
    }
}
