package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 * <p/>
 * Используется ручкой settings_setup_update_some
 */
public class SettingsSetupUpdateSomeObj extends Obj {

    /**
     * Возвращает объект готовый к назначению настройки
     *
     * @return SettingsSetupUpdateSomeObj
     */
    public static SettingsSetupUpdateSomeObj settings() {
        return new SettingsSetupUpdateSomeObj();
    }

    public static SettingsSetupUpdateSomeObj update(String setting, String value) {
        return settings().setUpdates(setting, value);
    }

    /**
     * Создает объект для включения определенной настройки
     *
     * @param setting - имя настройки
     * @return SettingsSetupUpdateSomeObj
     */
    public static SettingsSetupUpdateSomeObj getObjToTurnON(String setting) {
        return settings().setUpdates(setting, "on");
    }

    /**
     * Создает объект для выключения определенной настройки
     *
     * @param setting - имя настройки
     * @return SettingsSetupUpdateSomeObj
     */
    public static SettingsSetupUpdateSomeObj getObjToTurnOFF(String setting) {
        return settings().setUpdates(setting, "off");
    }

    /**
     * Включение/выключение настройки. Список можно просмотреть в settings_setup
     *
     * @param setting  - настройка
     * @param onOffSet - включить/выключить
     * @return SettingsSetupUpdateSomeObj
     */
    public SettingsSetupUpdateSomeObj setUpdates(String setting, String onOffSet) {
        set("updates", setting + "=" + onOffSet);
        return this;
    }

}
