package ru.yandex.autotests.innerpochta.wmi.core.obj;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 26.03.12
 * Time: 22:51
 */
public class ThreadListObj extends Obj {

    /**
     * Возвращает объект с настройками конкретного письма
     *
     * @return MessageObj
     */
    public static ThreadListObj getEmptyObj() {
        return new ThreadListObj();
    }

    /**
     * Возвращает объект, подготовленный для получения треда с заданным ид
     *
     * @param threadId - заданный ид треда
     * @return ThreadListObj
     */
    public static ThreadListObj getThread(String threadId) {
        return getEmptyObj().setThreadId(threadId);
    }

    /**
     * Выставляет идентификатор темы
     *
     * @param threadId - id темы
     * @return ThreadListObj
     */
    public ThreadListObj setThreadId(String threadId) {
        set("thread_id", threadId);
        return this;
    }


    /**
     * Нанзначение параметра требует уточнения
     * Похоже на группировку или сортировку
     * Бывает: byMailbox
     *
     * @param scope - id темы
     * @return ThreadListObj
     */
    public ThreadListObj setScope(String scope) {
        set("scope", scope);
        return this;
    }

    //-------------------------------------------------------
    public static final String SCOPE_BYMAILBOX = "byMailbox";
    //-------------------------------------------------------


    /**
     * @param first - номер первого заголовка в выдаче (начинается с 0)
     * @return this
     */

    public ThreadListObj setFirst(Integer first) {
        set("first", first.toString());
        return this;
    }

    /**
     * @param last - номер последнего заголовка в выдаче
     * @return this
     */

    public ThreadListObj setLast(Integer last) {
        set("last", last.toString());
        return this;
    }


}
