package ru.yandex.autotests.innerpochta.wmi.core.obj.factory;

import ru.yandex.autotests.innerpochta.objstruct.base.misc.Account;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailSendMsgObj;
import ru.yandex.autotests.innerpochta.wmi.core.rules.InitialComposeCheck;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 11:08
 */
public class MailSendMsgObjFactory {

    private String composeCheck;
    private InitialComposeCheck initialComposeCheck;
    private Account account;

    public MailSendMsgObjFactory setAccount(Account account) {
        this.account = account;
        return this;
    }

    public MailSendMsgObjFactory setComposeCheck(String composeCheck) {
        this.composeCheck = composeCheck;
        return this;
    }

    public MailSendMsgObjFactory setComposeCheck(InitialComposeCheck composeCheck) {
        this.initialComposeCheck = composeCheck;
        return this;
    }

    /**
     * Композ чек заполняется при создании объекта фабрики в криэйторе
     *
     * @return пустой объект письма с заполненным композ-чеком
     */
    public MailSendMsgObj getEmptyObj() {
        if (null != initialComposeCheck) {
            composeCheck = initialComposeCheck.get().getComposeCheckNodeValue();
        }

        return new MailSendMsgObj().setComposeCheck(composeCheck);
    }

    /**
     * Подготавливает отложенное письмо
     * Назначает время отправки равное текущему + некоторое время в миллисекундах
     * <p/>
     * Необходимо отправлять через SJSX ручку!
     *
     * @param millisOffset - прибавка ко времени в миллисекундах
     * @return - объект письма
     */
    public MailSendMsgObj getDelayedMsg(long millisOffset) {
        MailSendMsgObj msg = getEmptyObj()
                .setTo(account.getSelfEmail())
                .setFromMailbox(account.getSelfEmail())
                .setSubj(Util.getRandomString())
                .setSendTime(new Date(System.currentTimeMillis() + millisOffset));
        msg.setSend("Deliver at: " + msg.getSendTime());
        return msg;
    }

    /**
     * Подготавливает пустое письмо самому себе со случайной строкой вместо темы
     *
     * @return - объект письма с заполненной темой и адресатом
     */
    public MailSendMsgObj getSimpleEmptySelfMsg() {
        return getEmptyObj()
                .setTo(account.getSelfEmail())
                .setSubj(Util.getRandomString());
    }


    /**
     * Подготавливает пустое письмо самому себе со случайной строкой вместо темы
     * И сохраняет его в ЧЕРНОВИК
     * <p/>
     * Сохраняется в черновики только API ручкой
     *
     * @return - объект письма с заполненной темой и адресатом для сохранения в черновик
     */
    public MailSendMsgObj getSimpleEmptyMsgToDRAFT() {
        return getSimpleEmptySelfMsg()
                .setNosend("yes");
    }


    /**
     * Высылаем сохраненное письмо в черновике адресату
     *
     * @param mid - mid письма, сохраненного в Черновик
     * @return MailSendMsgObj
     */
    public MailSendMsgObj getSimpleEmptyMsgToSendFromDRAFT(String mid) {
        return getSimpleEmptySelfMsg()
                .setIgnOverwrite("no")
                .setOverwrite(mid);
    }

    /**
     * Пересылает указанное письмо самому себе
     *
     * @param mid     - мид письма для пересылки
     * @param subject - тема письма - будет образована новая тема вида "Rur:тема"
     * @return MailSendMsgObj
     */
    public MailSendMsgObj getForwardMsg(String mid, String subject) {
        return getEmptyObj()
                .setTo(account.getSelfEmail())
                .setFromMailbox(account.getSelfEmail())
                .setSubj("Fwd: " + subject)
                .setTtypePlain()
                .setMarkAs("forwarded")
                .setMarkIds(mid)
                .setOverwrite(mid)
                .setIgnOverwrite("yes")
                .setSend("Это сообщение было переслано");
    }

}
