package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 18.10.13
 * Time: 13:49
 * <p/>
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi
 */
public class AuthObj extends Obj {

    public static AuthObj empty() {
        return new AuthObj();
    }

    /**
     * Необязательный параметр, при значении yes
     * в выдачу будут добавлены внешние провалидированные адреса пользователя
     * (запрос тяжелый для паспорта, не злоупотреблять!)
     *
     * @param flag
     * @return AuthObj
     */
    public AuthObj setEmails(String flag) {
        set("emails", flag);
        return this;
    }

    public AuthObj setEmailsYes() {
        set("emails", "yes");
        return this;
    }

    public AuthObj setEmailsNo() {
        set("emails", "no");
        return this;
    }

    /**
     * Необязательный параметр, при наличии параметра
     * проверка кук не производится, считается,
     * что они не поддерживаются
     *
     * @param flag
     * @return AuthObj
     */
    public AuthObj setNocookieSupport(String flag) {
        set("nocookiesupport", flag);
        return this;
    }

    /**
     * Необязательный параметр, OAuth токен, в случае,
     * когда его хотят передавать через аргумент,
     * вместо стандартного способа передачи через заголовок
     *
     * @param token токен
     * @return AuthObj
     */
    public AuthObj setOAuthToken(String token) {
        set("oauth_token", token);
        return this;
    }

    /**
     * Необязательный параметр,
     * способ передачи куки Session_id через заголовок
     * (устарело, использовать не нужно).
     *
     * @param sid кука Session_id
     * @return AuthObj
     */
    public AuthObj setSid(String sid) {
        set("sid", sid);
        return this;
    }


    /**
     *
     * @param sid - один сид
     * @return
     */
    public AuthObj addSidsToCheck(String sid) {
        add("sids_to_check", sid);
        return this;
    }

    public AuthObj setCurrentUid(String uid) {
        set("current_uid", uid);
        return this;
    }

}


