package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 18.10.13
 * Time: 14:11
 * <p/>
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi
 */
public class FilterSearchObj extends Obj {

    public static FilterSearchObj empty() {
        return new FilterSearchObj();
    }

    //DARIA-39024
    public FilterSearchObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public FilterSearchObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public FilterSearchObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    public FilterSearchObj setConnectionId(String id) {
        set("connection_id", id);
        return this;
    }

    //full_folders_and_labels DARIA-49570
    public FilterSearchObj setFullFoldersAndLabels(String param) {
        set("full_folders_and_labels", param);
        return this;
    }

    /**
     * Задает список фильтруемых писем
     *
     * @param mids множество mid, как список одноименных параметров
     * @return FilterSearchObj
     */
    public FilterSearchObj setMids(String... mids) {
        for (String mid : mids) {
            add("mids", mid);
        }
        return this;
    }

    /**
     * Если задан, то выдавать только письма в заданных папках
     *
     * @param fids множество fid, как список одноименных параметров
     * @return FilterSearchObj
     */
    public FilterSearchObj setFids(String... fids) {
        set("fids", fids);
        return this;
    }

    /**
     * Если задан, то выдавать только письма с заданными метками
     *
     * @param lids множество lid, как список одноименных параметров
     * @return FilterSearchObj
     */
    public FilterSearchObj setLids(String... lids) {
        set("lids", lids);
        return this;
    }

    /**
     * Если не пуст, то выдавать только непрочитанные письма;
     *
     * @return FilterSearchObj
     */
    public FilterSearchObj setUnread(String flag) {
        set("unread", flag);
        return this;
    }

    /**
     * Если не пуст, то выдавать письма только с вложениями;
     *
     * @param flag
     * @return FilterSearchObj
     */
    public FilterSearchObj setOnlyAttachments(String flag) {
        set("only_attachments", flag);
        return this;
    }

    /**
     * Порядок сортировки в ответе
     *
     * @param order default, date, date1, subject, subject1, from, from1, size, size1
     * @return FilterSearchObj
     */
    public FilterSearchObj setOrder(String order) {
        set("order", order);
        return this;
    }

    /**
     * Дополнительные ограничения для тимовской почты на местоположение писем
     *
     * @param folderSet default, private_subscribed, private_opened_allowed, opened_allowed
     * @return FilterSearchObj
     */
    public FilterSearchObj setFolderSet(String folderSet) {
        set("folder_set", folderSet);
        return this;
    }

    /**
     * DARIA-48664
     */
    public FilterSearchObj setDbtype(String dbtype) {
        set("dbtype", dbtype);
        return this;
    }

    /**
     * PS-1360
     * incl_folders : указываются символы папок, которые надо включить в запрос;
     */
    public FilterSearchObj withInclFolders(Symbol... inclfolders) {
        set("incl_folders", Stream.of(inclfolders).map(Object::toString)
                .collect(toList()).toArray(new String[inclfolders.length]));
        return this;
    }

    /**
     * PS-1360
     * excl_folders : указываются символы папок, которые надо исключить из запроса.
     */
    public FilterSearchObj withExclFolders(Symbol... exclfolders) {
        set("excl_folders", Stream.of(exclfolders).map(Object::toString)
                .collect(toList()).toArray(new String[exclfolders.length]));
        return this;
    }
    
    /**
     * PS-1360
     * отфильтровывает отправленные письма
     */
    public FilterSearchObj withOnlyUseful() {
        set("only_useful", "1");
        return this;
    }

    public FilterSearchObj history() {
        set("history", "");
        return this;
    }

    public FilterSearchObj needMailboxRevision (String yes) {
        set("need_mailbox_revision", yes);
        return this;
    }
}
