package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

public class MessagesByFolderAndTabObj extends Obj {

    public static MessagesByFolderAndTabObj empty() {
        return new MessagesByFolderAndTabObj();
    }

    public MessagesByFolderAndTabObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public MessagesByFolderAndTabObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public MessagesByFolderAndTabObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public MessagesByFolderAndTabObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param fid (обязательный) -  id запрашиваемой папки;
     * @return
     */
    public MessagesByFolderAndTabObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param tab (обязательный) - имя таба, для которого нужно отдать сообщения;
     * @return
     */
    public MessagesByFolderAndTabObj setTab(String tab) {
        set("tab", tab);
        return this;
    }
}
