package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 17:10
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi#pisma
 * suid, mdb, connection_id, first/page, count, fid, sort_type
 * можно использовать и для messages_in_folder_with_pins
 */
public class MessagesByFolderObj extends Obj {

    public static MessagesByFolderObj empty() {
        return new MessagesByFolderObj();
    }

    //DARIA-39024
    //Для апи метода нет необходимости в uid/suid/mdb
    public MessagesByFolderObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public MessagesByFolderObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public MessagesByFolderObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }
    //////////////////////////////////

    public MessagesByFolderObj setConnectionId(String connectionId) {
        set("connection_id", connectionId);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public MessagesByFolderObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public MessagesByFolderObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public MessagesByFolderObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param fid (обязательный) -  id запрашиваемой папки;
     * @return
     */
    public MessagesByFolderObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * [DARIA-34367]
     *
     * @param since
     * @return
     */
    public MessagesByFolderObj setSince(String since) {
        set("since", since);
        return this;
    }

    /**
     * [DARIA-34367]
     *
     * @param till
     * @return
     */
    public MessagesByFolderObj setTill(String till) {
        set("till", till);
        return this;
    }

    /**
     * @param type date_descending
     *             date_ascending
     *             subject_descending
     *             subject_ascending
     *             from_descending
     *             from_ascending
     *             to_descending
     *             to_ascending
     *             size_descending
     *             size_ascending
     * @return
     */
    public MessagesByFolderObj setSortType(String type) {
        set("sort_type", type);
        return this;
    }

    public MessagesByFolderObj setTid(String tid) {
        set("tid", tid);
        return this;
    }
}
