package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 17:10
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi#pisma
 * suid, mdb, connection_id, first/page, count, fid, sort_type
 * можно использовать и для messages_in_folder_with_pins
 */
public class MessagesByFolderWithoutLabelObj extends Obj {

    public static MessagesByFolderWithoutLabelObj empty() {
        return new MessagesByFolderWithoutLabelObj();
    }

    public MessagesByFolderWithoutLabelObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public MessagesByFolderWithoutLabelObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public MessagesByFolderWithoutLabelObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    public MessagesByFolderWithoutLabelObj setConnectionId(String connectionId) {
        set("connection_id", connectionId);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public MessagesByFolderWithoutLabelObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public MessagesByFolderWithoutLabelObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public MessagesByFolderWithoutLabelObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param fid (обязательный) -  id запрашиваемой папки;
     * @return
     */
    public MessagesByFolderWithoutLabelObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param lid (обязательный) - id метки, которую нужно исключить;
     * @return
     */
    public MessagesByFolderWithoutLabelObj setLid(String lid) {
        set("lid", lid);
        return this;
    }

    /**
     * @param type date_descending
     *             date_ascending
     *             subject_descending
     *             subject_ascending
     *             from_descending
     *             from_ascending
     *             to_descending
     *             to_ascending
     *             size_descending
     *             size_ascending
     * @return
     */
    public MessagesByFolderWithoutLabelObj setSortType(String type) {
        set("sort_type", type);
        return this;
    }
}
