package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 17:09
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi#pisma
 * suid, mdb, connection_id, first/page, count, lid, sort_type:
 */
public class MessagesByLabelObj extends Obj {

    public static MessagesByLabelObj empty() {
        return new MessagesByLabelObj();
    }

    //DARIA-39024
    public MessagesByLabelObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public MessagesByLabelObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public MessagesByLabelObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    public MessagesByLabelObj setConnectionId(String connectionId) {
        set("connection_id", connectionId);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку)
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public MessagesByLabelObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку)
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public MessagesByLabelObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись
     * @return
     */
    public MessagesByLabelObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param lid (обязательный) -  id запрашиваемой метки;
     * @return
     */
    public MessagesByLabelObj setLid(String lid) {
        set("lid", lid);
        return this;
    }

    /**
     * @param type date_descending
     *             date_ascending
     *             subject_descending
     *             subject_ascending
     *             from_descending
     *             from_ascending
     *             to_descending
     *             to_ascending
     *             size_descending
     *             size_ascending
     * @return
     */
    public MessagesByLabelObj setSortType(String type) {
        set("sort_type", type);
        return this;
    }
}
