package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 17:09
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi#pisma
 * suid, mdb, connection_id, first/page, count, tid, sort_type:
 */
public class MessagesByThreadObj extends Obj {

    public static MessagesByThreadObj empty() {
        return new MessagesByThreadObj();
    }

    //DARIA-39024
    public MessagesByThreadObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public MessagesByThreadObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public MessagesByThreadObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    public MessagesByThreadObj setConnectionId(String connectionId) {
        set("connection_id", connectionId);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public MessagesByThreadObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public MessagesByThreadObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public MessagesByThreadObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param tid (обязательный) -  id запрашиваемого треда
     * @return
     */
    public MessagesByThreadObj setTid(String tid) {
        set("tid", tid);
        return this;
    }

    /**
     * @param type date_descending
     *             date_ascending
     *             subject_descending
     *             subject_ascending
     *             from_descending
     *             from_ascending
     *             to_descending
     *             to_ascending
     *             size_descending
     *             size_ascending
     * @return
     */
    public MessagesByThreadObj setSortType(String type) {
        set("sort_type", type);
        return this;
    }
}
