package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 17:11
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi#pisma
 * suid, mdb, connection_id, first/page, count, sort_type:
 */
public class MessagesWithAttachesObj extends Obj {

    public static MessagesWithAttachesObj empty() {
        return new MessagesWithAttachesObj();
    }

    //DARIA-39024
    public MessagesWithAttachesObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public MessagesWithAttachesObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public MessagesWithAttachesObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    public MessagesWithAttachesObj setConnectionId(String connectionId) {
        set("connection_id", connectionId);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public MessagesWithAttachesObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public MessagesWithAttachesObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public MessagesWithAttachesObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param fid (обязательный) -  id запрашиваемой папки;
     * @return
     */
    public MessagesWithAttachesObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param type date_descending
     *             date_ascending
     *             subject_descending
     *             subject_ascending
     *             from_descending
     *             from_ascending
     *             to_descending
     *             to_ascending
     *             size_descending
     *             size_ascending
     * @return
     */
    public MessagesWithAttachesObj setSortType(String type) {
        set("sort_type", type);
        return this;
    }
}
