package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 04.09.15
 * Time: 17:22
 */
public class RemindMessageObj extends Obj {

    public static RemindMessageObj empty() {
        return new RemindMessageObj();
    }

    public RemindMessageObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public RemindMessageObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public RemindMessageObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    /**
     * @param mid (обязательный) - mid оригинального письма;
     * @return
     */
    public RemindMessageObj setMid(String mid) {
        set("mid", mid);
        return this;
    }

    /**
     * @param lang (обязательный) - язык пользователя (на котором посылать письмо);
     * @return
     */
    public RemindMessageObj setLang(String lang) {
        set("lang", lang);
        return this;
    }

    /**
     * @param date (обязательный) - дата посылки оригинального письма;
     * @return
     */
    public RemindMessageObj setDate(String date) {
        set("date", date);
        return this;
    }

    /**
     * @param account (обязательный) - адрес пользователя (на который ему послать напоминание)
     * @return
     */
    public RemindMessageObj setAccount(String account) {
        set("account", account);
        return this;
    }


}
