package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

public class ThreadsByFolderAndTabObj extends Obj {

    public static ThreadsByFolderAndTabObj empty() {
        return new ThreadsByFolderAndTabObj();
    }

    public ThreadsByFolderAndTabObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public ThreadsByFolderAndTabObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public ThreadsByFolderAndTabObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public ThreadsByFolderAndTabObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param fid (обязательный) -  id запрашиваемой папки;
     * @return
     */
    public ThreadsByFolderAndTabObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param tab (обязательный) - имя таба, для которого нужно отдать сообщения;
     * @return
     */
    public ThreadsByFolderAndTabObj setTab(String tab) {
        set("tab", tab);
        return this;
    }
}
