package ru.yandex.autotests.innerpochta.wmi.core.obj.hound;

import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 17:09
 * http://wiki.yandex-team.ru/users/jkennedy/ywmiapi#threadsbyfolder
 * suid, mdb, connection_id, first/page, count, fid:
 * можно использовать и для threads_in_folder_with_pins
 */
public class ThreadsByFolderObj extends Obj {

    public static ThreadsByFolderObj empty() {
        return new ThreadsByFolderObj();
    }

    //DARIA-39024
    public ThreadsByFolderObj setUid(String uid) {
        set("uid", uid);
        return this;
    }

    public ThreadsByFolderObj setSuid(String suid) {
        set("suid", suid);
        return this;
    }

    public ThreadsByFolderObj setMdb(String mdb) {
        set("mdb", mdb);
        return this;
    }

    /**
     * @param first (обязательный)/page
     *              начиная с какой выдавать записи (учитывая сортировку);
     *              задается либо номером записи
     *              first (начиная с 0), либо номером страницы
     * @return
     */
    public ThreadsByFolderObj setFirst(String first) {
        set("first", first);
        return this;
    }

    /**
     * @param page (обязательный)/first
     *             начиная с какой выдавать записи (учитывая сортировку);
     *             задается номером записи
     *             page (с 1)
     * @return
     */
    public ThreadsByFolderObj setPage(String page) {
        set("page", page);
        return this;
    }

    /**
     * @param count (обязательный) - количество записей в ответе,
     *              если задан параметр page, то выдается count+1 запись;
     * @return
     */
    public ThreadsByFolderObj setCount(String count) {
        set("count", count);
        return this;
    }

    /**
     * @param fid (обязательный) - id запрашиваемой папки;
     * @return
     */
    public ThreadsByFolderObj setFid(String fid) {
        set("fid", fid);
        return this;
    }

    /**
     * @param unixTimestamp таймстемп
     * @return
     */
    public ThreadsByFolderObj setSince(String unixTimestamp) {
        set("since", unixTimestamp);
        return this;
    }

    /**
     * @param unixTimestamp таймстемп
     * @return
     */
    public ThreadsByFolderObj setTill(String unixTimestamp) {
        set("till", unixTimestamp);
        return this;
    }
}
