package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import java.io.IOException;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 23.03.12
 * Time: 14:54
 * в sjsx нету
 */

@OperClass(
        apicommand = "account_information",
        jsxcommand = "account_information",
        description = "Запрос информации о пользователе"
)
public class AccountInformation extends Oper<AccountInformation> {

    public static Via accountInformation() throws IOException {
        return api(AccountInformation.class).post();
    }

    public String getUid() {
        return documentConverter.byXpath("//uid").asString();
    }

    public String getSuid() {
        return documentConverter.byXpath("//suid").asString();
    }

    public String getDb() {
        return documentConverter.byXpath("//db").asString();
    }

    public String getRedirectTo() {
        return documentConverter.byXpath("//redirect_to").asString();
    }

    public String getReason() {
        return documentConverter.byXpath("//reason").asString();
    }

    public String getLogin() {
        return documentConverter.byXpath("//login").asString();
    }

    public String getBbConnectionId() {
        return documentConverter.byXpath("//bb_connection_id").asString();
    }

    public void hasAttribute(String attrName, Matcher<String> matcher) {
        String value = documentConverter.byXpath("//attributes/" + attrName).asString();
        assertThat("Неверное значение атрибута", value, matcher);
    }
}
