package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "get_best_language",
        description = "Вывод предпочитаемого языка"
)
public class GetBestLanguage extends Oper<GetBestLanguage> {


    /**
     * Достаем значение языка
     *
     * @return узел со значением
     */
    public String getLang() {
        try {
            XPathExpression expr = XPathFactory.newInstance().newXPath().compile("//desired_locale/text()");
            String lang = expr.evaluate(toDocument());

            // Логирование
            logger.info("Локаль: " + lang);

            return lang;
        } catch (XPathExpressionException ignore) {
        }
        return null;
    }

}
