package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 21.05.14
 * Time: 14:21
 *
 * Сделали тут:
 * [DARIA-35854]
 */
@OperClass(
        jsxcommand = "get_city_lingvo_by_ip",
        description = "Возвращаем склонение города по IP"
)
public class GetCityLingvoByIp extends Oper<GetCityLingvoByIp> {

    public GetCityLingvoByIp shouldSeeSeeCase(String caseFor, String expected) {
        assertThat(documentConverter.byXpath(caseFor).asString(), equalTo(expected));
        return this;
    }

    public GetCityLingvoByIp nominateCase(String expected) {
      return shouldSeeSeeCase("//nominative_case", expected);
    }

    public GetCityLingvoByIp genitiveCase(String expected) {
        return shouldSeeSeeCase("//genitive_case", expected);
    }

    public GetCityLingvoByIp dativeCase(String expected) {
        return shouldSeeSeeCase("//dative_case", expected);
    }

    public GetCityLingvoByIp prepositionalCase(String expected) {
        return shouldSeeSeeCase("//prepositional_case", expected);
    }

    public GetCityLingvoByIp preposition(String expected) {
        return shouldSeeSeeCase("//preposition", expected);
    }

    public GetCityLingvoByIp locativeCase(String expected) {
        return shouldSeeSeeCase("//locative_case", expected);
    }

    public GetCityLingvoByIp directionalCase(String expected) {
        return shouldSeeSeeCase("//directional_case", expected);
    }
}
