package ru.yandex.autotests.innerpochta.wmi.core.oper;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;

import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "get_country",
        description = "Вывод страны"
)
public class GetCountry extends Oper<GetCountry> {


    /**
     * Достаем значение страны
     *
     * @return узел со значением  из <country>ru</country>
     */
    public String getCountry() {
        try {
            XPathExpression expr = XPathFactory.newInstance().newXPath().compile("//get_country/country/text()");
            String country = expr.evaluate(toDocument());

            // Логирование
            logger.info("Страна: " + country);

            return country;
        } catch (XPathExpressionException ignore) {
        }
        return null;
    }

    /**
     *  Получаем номера регионов
     *
     *  @return узел со значением  из
     *  <region_parents>9999,213,1,3,225,10001,10000</region_parents>
     */
    public String getRegionParents() {
        return documentConverter.byXpath("//region_parents/text()").asString();
    }


    public GetCountry haveCountry(Matcher<String> matcher) {
        assertThat("Ответ содержит не ту страну ", getCountry(), matcher);
        return this;
    }

    public GetCountry haveRegionParents(Matcher<String> matcher) {
        assertThat("Ответ содержит не те номера регионов ", getRegionParents(), matcher);
        return this;
    }
}
