package ru.yandex.autotests.innerpochta.wmi.core.oper;

import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmicommon.Util;

import javax.xml.xpath.XPathExpression;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import static org.junit.Assert.fail;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 */
@OperClass(
        jsxcommand = "get_first_envelope_date",
        description = "Вывод даты первого письма в папке"
)
public class GetFirstEnvelopeDate extends Oper<GetFirstEnvelopeDate> {


    /**
     * Получив ответ от ручки с разбитой по тегам датой и временем (точность до секунд),
     * собираем все это дело в объект даты, смещаем на нужное количество минут в ту или иную сторону,
     * и возвращаем в формате, который может принять пейджер
     *
     * @param minOffset - смещение времени в секундах
     *                  т.к. действуют жесткие правила < или > на параметры в пейджере, чтобы первое письмо,
     *                  определенное этой ручкой попало в выдачу, нужно уменьшить время, дабы оно не было равно
     *                  времени письма
     * @return - строка, время и дата первого письма в формате HH:mm:ss dd.MM.yyyy
     */
    public String datetimeOfFirstEnvelope(int minOffset) {

        XPathExpression expr = null;
        try {

            Object result = documentConverter.byXpath("//date/year/text()").asString();
            String year = (String) result;

            result = documentConverter.byXpath("//date/month/text()").asString();
            String month = (String) result;

            result = documentConverter.byXpath("//date/day/text()").asString();
            String day = (String) result;

            result = documentConverter.byXpath("//date/hour/text()").asString();
            String hour = (String) result;

            result = documentConverter.byXpath("//date/min/text()").asString();
            String min = (String) result;

            result = documentConverter.byXpath("//date/sec/text()").asString();
            String sec = (String) result;


            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss dd.MM.yyyy");
            Date date = format.parse(hour + ":" + min + ":" + sec + " " + day + "." + month + "." + year);
            date.setTime(date.getTime() + minOffset * 60000);
            // date.setMinutes(date.getMinutes() + minOffset);

            // Логирование
            logger.info("Дата первого письма: " + format.format(date));

            return format.format(date);
        } catch (ParseException e) {
            e.printStackTrace();
            fail("Ошибка при парсинге полученных значений даты");
            return null;
        }
    }

    /**
     * В пустой папке выдача пуста и кроме тега, удаляемого здесь, ничего не содержит
     *
     * @return true, если выдача ручки пуста
     */
    public boolean isGetFirstEnvelopeDateEmpty() {
        Util.removeAllNodesFromXml(toDocument(), "timer_logic");
        return !toDocument().getFirstChild().hasChildNodes();
    }

}
